#ifndef __CF_FLASH__
  #define __CF_FLASH__
  #include "derivative.h"
  
  #define FLASH_MASS_ERASE_CMD  0x41
  #define FLASH_ERASE_CMD       0x40
  #define FLASH_PROGRAM_CMD     0x20
  #define FLASH_BURST_CMD       0x25
  
  #define BUS_CLOCK    24000000
  
  #if BUS_CLOCK > 12800000
    #define FLASH_CLOCK (unsigned char)((BUS_CLOCK/1600000) + 0x40)
  #else
//    #define FLASH_CLOCK (unsigned char)(BUS_CLOCK/200000)
    #define FLASH_CLOCK (unsigned char)(BUS_CLOCK/175000)
  #endif
  
  /* Macros to call the function using the different features */
  #define Flash_Erase(Address) \
          Flash_Cmd((unsigned long)Address, (unsigned int)1, (unsigned long*) 0x800000, FLASH_ERASE_CMD)
  
  #define Flash_Program(Address, Data) \
          Flash_Cmd((unsigned long)Address, (unsigned int)1, (unsigned long*)&Data, FLASH_PROGRAM_CMD)
  
  #define Flash_Burst(Address, Size, DataPtr) \
          Flash_Cmd((unsigned long)Address, (unsigned int)Size, (unsigned long*)DataPtr, FLASH_BURST_CMD)
          
  //#pragma CODE_SEG FLASH_ROUTINES
  #pragma CODE_SEG __FAR_SEG CopyToRAM
  unsigned char far Flash_Cmd(unsigned long FlashAddress, unsigned int FlashDataCounter, unsigned long* pFlashDataPtr, unsigned char FlashCommand);
  
  #pragma CODE_SEG DEFAULT
  void FlashInit(void);
  void CopyInRAM(void);
#endif
