/**************************************************************************************************
 *  Services performed by FREESCALE in this matter are performed AS IS and without any warranty.  *
 *  CUSTOMER retains the final decision relative to the total design and functionality of the     *
 *  end product. FREESCALE neither guarantees nor will be held liable by CUSTOMER for the         *
 *  success of this project. FREESCALE disclaims all warranties, express, implied or statutory    *
 *  including, but not limited to, implied warranty of merchantability or fitness for a           *
 *  particular purpose on any hardware, software ore advise supplied to the project by FREESCALE, *
 *  and or any product resulting from FREESCALE services . In no event shall FREESCALE be         *
 *  liable for incidental or consequential damages arising out of this agreement. CUSTOMER        *
 *  agrees to hold FREESCALE harmless against any and all claims demands or actions by anyone     *
 *  on account of any damage, or injury, whether commercial, contractual, or tortuous, rising     *
 *  directly or indirectly as a result of the advise or assistance supplied CUSTOMER in           *
 *  connection with product, services or goods supplied under this Agreement.                     *
 **************************************************************************************************/

#include <stdio.h>
#include "derivative.h" /* include peripheral declarations */

#include "ADC.h"
#include "DAC.h"
#include "Amplifiers.h"
#include "twrpi_slcd.h"
#include "Thermodevices.h"

/********************************************************************************************/
int main (void)
{
  /* Initialize TWRPI LCD */
  vfnLCD_PinMux_init ();    
    
  /* Initialize ADC0 and ADC1 and Set DAC to output 1.0V base from 3.3V reference */ 
  ADC0_Init16b();
  ADC1_Init16b();
  DAC12_Vin_SWtrig();
  
  /* Initialize TRIAMP0 and OPAMP0 for enabling the Thermocouple */
  vfnThermocouple_init();
 
  /* Initialize pins and OPAMP1 for enabling the Thermistor */
  vfnThermistor_init();
  
  /* Initialize pins for LEDs indicators and IRQ1 for device selector */
  vfnInit_LEDs_IRQ();
  
  for(;;) 
  {	
	if (!selector)
	{
  	  //Measure Thermocouple 
	  vfnThermocouple_measuring();	  
	}
	else
	{
	  //Measure Thermistor 
	  vfnThermistor_measuring();
	}
	
	if (average_number < AVERAGE_QUANTITY)
	{
		temperature_average += temperature_result;
		temperature_average = (temperature_average>>1);
		average_number++;
	}	
	else
	{
	  //Printing temperature on LCD
	  vfnLCD_print_value(temperature_result);		
	  //Delay
	  vfnDelay(5000000);
	  average_number = 0;
	}	
  }
  return 0;
}

/********************************************************************************************/
