/************************************************************************/
/* STM interrupt project for Pictus                                     */
/* Motoki Sakurai (r42789) 14/09/2009 					*/
/************************************************************************/

#include "mpc5675k-2.02.h"
#include "siu.h"

/**************************************************************************/
/* FUNCTION     : setup_siu                                           */
/**************************************************************************/
void setup_siu(void)
{    

   SIU.PCR[0].R = ALT0 | OBE;             // STM ch0
   SIU.PCR[1].R = ALT0 | OBE;             // STM ch1
   SIU.PCR[2].R = ALT0 | OBE;             // STM ch2
   SIU.PCR[3].R = ALT0 | OBE;             // STM ch3
}

/************************************************************************/
/*															GPIO PAD configuration									*/
/************************************************************************/
void PCR_Config4GPO0_15_init(void)
{
	SIU.PCR[ 0].R = ALT0 | OBE;	//PA=0, OBE=1 for GPIO[0] PA[0] 
	SIU.PCR[ 1].R = ALT0 | OBE;	//PA=0, OBE=1 for GPIO[0] PA[1]
	SIU.PCR[ 2].R = ALT0 | OBE;	//PA=0, OBE=1 for GPIO[0] PA[2]
	SIU.PCR[ 3].R = ALT0 | OBE;	//PA=0, OBE=1 for GPIO[0] PA[3]
	SIU.PCR[ 4].R = ALT0 | OBE;	//PA=0, OBE=1 for GPIO[0] PA[4]
	SIU.PCR[ 5].R = ALT0 | OBE;	//PA=0, OBE=1 for GPIO[0] PA[5]
	SIU.PCR[ 6].R = ALT0 | OBE;	//PA=0, OBE=1 for GPIO[0] PA[6]
	SIU.PCR[ 7].R = ALT0 | OBE;	//PA=0, OBE=1 for GPIO[0] PA[7]
	SIU.PCR[ 8].R = ALT0 | OBE;	//PA=0, OBE=1 for GPIO[0] PA[8]
	SIU.PCR[ 9].R = ALT0 | OBE;	//PA=0, OBE=1 for GPIO[0] PA[9]
	SIU.PCR[10].R = ALT0 | OBE;	//PA=0, OBE=1 for GPIO[0] PA[10]
	SIU.PCR[11].R = ALT0 | OBE;	//PA=0, OBE=1 for GPIO[0] PA[11]
	SIU.PCR[12].R = ALT0 | OBE;	//PA=0, OBE=1 for GPIO[0] PA[12]
	SIU.PCR[13].R = ALT0 | OBE;	//PA=0, OBE=1 for GPIO[0] PA[13]
	SIU.PCR[14].R = ALT0 | OBE;	//PA=0, OBE=1 for GPIO[0] PA[14]
	SIU.PCR[15].R = ALT0 | OBE;	//PA=0, OBE=1 for GPIO[0] PA[15]
}	

void eTimer1_ch2_setup(void)
{
  SIU.PCR[46].R = ALT1 | SRC; //Output on Port B[0]  ALT1 Ch2 eTimer1 ETC[2]
  SIU.PCR[45].R = ALT1; //Output on Port C[13]  ALT1 Ch2 eTimer1 ETC[1]
  SIU.PCR[93].R = ALT1 | SRC; //Output on Port D[4]  ALT1 Ch2 eTimer1 ETC[4]
  
}
