/**************************************************************************/
/* PROJECT: Interrupts in Decoupled Parallel Mode for MPC5675K	          */ 
/* FILE NAME: MPC56xx_55xx_Dual_PRC0_Interrupt_Init.c        	          */
/* DESCRIPTION:                                                           */
/* This is the interrupt controller configuration file.                   */
/*========================================================================*/
/* REV      AUTHOR        DATE        DESCRIPTION OF CHANGE               */
/* ---   -----------    ----------    ---------------------               */
/* 0.2    T.Kulig	 16/02/2012    Modified for both cores
/* 0.1    R. Moran       10/12/2008    Initial Version                    */
/**************************************************************************/
/*  LICENSE: 
 *  Copyright (c) 2012 Freescale Semiconductor
 *  
 *  Permission is hereby granted, free of charge, to any person 
 *  obtaining a copy of this software and associated documentation 
 *  files (the "Software"), to deal in the Software without 
 *  restriction, including without limitation the rights to use, 
 *  copy, modify, merge, publish, distribute, sublicense, and/or 
 *  sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following 
 *  conditions:
 *  
 *  The above copyright notice and this permission notice 
 *  shall be included in all copies or substantial portions 
 *  of the Software.
 *  
 *  THIS SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
 *  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES 
 *  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 *  NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT 
 *  HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
 *  WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
***************************************************************************/


#include "..\header\mpc5675k-0200.h"

/*========================================================================*/
/*                      GLOBAL VARIABLES                                  */
/*========================================================================*/

extern const uint32_t IntcIsrVectorTable[];
extern const uint32_t IntcIsrVectorTable_PRC1[];

/*========================================================================*/
/*                      EXTERNAL PROTOTYPES                               */
/*========================================================================*/

extern void e200zX_Interrupt_Setup (void);
extern void e200zX_Interrupt_Setup_1 (void);

/*========================================================================*/
/*                          FUNCTIONS                                     */
/*========================================================================*/
/*========================================================================*/
/*                     INTERRUPT PRIORITIES                               */
/*========================================================================*/
/**************************************************************************/
/* FUNCTION     : Init_INTC_Priority - Core0                                      */
/* PURPOSE      : SET Interrupt Vector PRIORITIES HERE                    */
/**************************************************************************/
void Init_INTC_Priority(void)
{
      // SSI0 IRQ
     INTC_0.PSR[0].B.PRI = 0;	//setting priority of main function (normal code) to 0 - the lowest priority
}
/**************************************************************************/
/* FUNCTION     : Init_INTC_Priority - Core1                                     */
/* PURPOSE      : SET Interrupt Vector PRIORITIES HERE                    */
/**************************************************************************/
void Init_INTC_Priority1(void)
{
      // SSI0 IRQ
     INTC_1.PSR[0].B.PRI = 0;	//setting priority of main function (normal code) to 0 - the lowest priority    
}

/**************************************************************************/
/* FUNCTION     : InitINTC - Core0                                               */
/* PURPOSE      : This function intializes the INTC for software vector   */
/*                mode.                                                   */
/**************************************************************************/
void InitINTC(void) {   
    
    // Choose software (HVEN=0) or hardware (HVEN=1) vector mode
    INTC_0.BCR.B.HVEN_PRC0 = 0;
        
    // Use the default vector table entry offsets of 4 bytes
    INTC_0.BCR.B.VTES_PRC0 = 0;
    
    // Set INTC ISR vector table base addr.
    INTC_0.IACKR_PRC0.R = (uint32_t) &IntcIsrVectorTable[0]; 
}

/**************************************************************************/
/* FUNCTION     : InitINTC - Core1					  */
/* PURPOSE      : This function intializes the INTC for software vector   */
/*                mode.                                                   */
/**************************************************************************/
void InitINTC1(void) {   
    
    // Choose software (HVEN=0) or hardware (HVEN=1) vector mode
    INTC_1.BCR.B.HVEN_PRC0 = 0;
    
    // Use the default vector table entry offsets of 4 bytes
    INTC_1.BCR.B.VTES_PRC0 = 0;
    
    // Set INTC ISR vector table base addr.
    INTC_1.IACKR_PRC0.R = (uint32_t) &IntcIsrVectorTable_PRC1[0]; 
}

/**************************************************************************/
/* FUNCTION     : enableIrq - Core0                                              */
/* PURPOSE      : This function sets INTC's current priority to 0.        */
/*                External interrupts to the core are enabled.            */
/**************************************************************************/
void enableIrq(void) {
    
    // Ensure INTC's current priority is 0
    INTC_0.CPR_PRC0.B.PRI = 0;
    
    // Enable external interrupts
    asm(" wrteei 1");       
}
/**************************************************************************/
/* FUNCTION     : enableIrq - Core1                                               */
/* PURPOSE      : This function sets INTC's current priority to 0.        */
/*                External interrupts to the core are enabled.            */
/**************************************************************************/
void enableIrq1(void) {
    
    // Ensure INTC's current priority is 0
    INTC_1.CPR_PRC0.B.PRI = 0;
    
    // Enable external interrupts
    asm(" wrteei 1");       
}

/**************************************************************************/
/* FUNCTION     : xcptn_xmpl - Core0                                             */
/* PURPOSE      : This function sets up the necessary functions to raise  */
/*                and handle a SWT Interrupt in hardware vector mode      */
/**************************************************************************/
void xcptn_xmpl(void) {
    
    // Initialise Core IVPR and IVOR Registers
    e200zX_Interrupt_Setup();       
    
    // Initialize INTC for hardware vector mode
    InitINTC();               
    
    // Initialise Interrupt Priorities - set in "ISR_Routines.c"
    Init_INTC_Priority();

    //enable interrupt
    enableIrq();
}

/**************************************************************************/
/* FUNCTION     : xcptn_xmpl - Core1                                              */
/* PURPOSE      : This function sets up the necessary functions to raise  */
/*                and handle a SWT Interrupt in hardware vector mode      */
/**************************************************************************/
void xcptn_xmpl1(void) {
    
    // Initialise Core IVPR and IVOR Registers
    e200zX_Interrupt_Setup_1();       
    
    // Initialize INTC for hardware vector mode
    InitINTC1();               
    
    // Initialise Interrupt Priorities - set in "ISR_Routines.c"
    Init_INTC_Priority1();

    //enable interrupt
    enableIrq1();
}
