/* main.c - SGL example to generate monotonic sounds */
/* Jan 11 2012 S Mihalik - Initial version */ 
/* Copyright Freescale Semiconductor, Inc 2012 All rights reserved. */

#include "MPC5606S_M07N.h"        /* Use proper include file */
  vuint32_t i = 0;	              /* Dummy idle counter */
  vuint32_t j = 0;	              /* Dummy timeout counter */

void initModesAndClock(void) {
  ME.MER.R = 0x0000001D;          /* Enable DRUN, RUN0, SAFE, RESET modes */
                                  /* Initialize PLL before turning it on: */
  CGM.FMPLL[0].CR.R = 0x02400100;    /* 8 MHz xtal: Set PLL0 to 64 MHz */   
  ME.RUN[0].R = 0x001F0074;       /* RUN0 cfg: 16MHzIRCON,OSC0ON,PLL0ON,syclk=PLL0 */
  ME.RUNPC[1].R = 0x00000010; 	  /* Peri. Cfg. 1 settings: only run in RUN0 mode */
  ME.PCTL[62].R = 0x01;           /* SGL   : select ME.RUNPC[1] */  
  ME.PCTL[68].R = 0x01;           /* SIUL  : select ME.RUNPC[1] */  
  ME.PCTL[73].R = 0x01;           /* EMIOS1: select ME.RUNPC[1] */  
  ME.MCTL.R = 0x40005AF0;         /* Enter RUN0 Mode & Key */
  ME.MCTL.R = 0x4000A50F;         /* Enter RUN0 Mode & Inverted Key */  
  while (ME.GS.B.S_MTRANS == 1) {}    /* Wait for mode transition to complete */    
  while(ME.GS.B.S_CURRENTMODE != 4) {} /* Verify RUN0 is the current mode */
}

void initPeriClkGen(void) {
  CGM.SC_DC[0].R = 0x80;        /* Enable peri set 1 (SGM) with sysclk/1 */
  CGM.AC2_SC.R   = 0x03000000;  /* Aux Clk2 (EMIOS_1): select PLL for clock source */
  CGM.AC2_DC.R   = 0x80000000;  /* Aux Clk2 (EMIOS_1): enable input clk= Aux Clk2 / 1 */
}

void disableWatchdog(void) {
  SWT.SR.R = 0x0000c520;     /* Write keys to clear soft lock bit */
  SWT.SR.R = 0x0000d928; 
  SWT.CR.R = 0x8000010A;     /* Clear watchdog enable (WEN) */
}        

void initEMIOS_1(void) {  
  /* eMIOS 1 chan 17:  Provide audio frequency to SGL Mux A */
  EMIOS_1.CH[17].CADR.R = 500;      /* Count n eMIOS clocks for OWPFMB duty cycle */
  EMIOS_1.CH[17].CBDR.R = 1000;     /* Count n eMIOS clocks for OWPFMB period */
  EMIOS_1.CH[17].CCR.R= 0x02000058; /* UCPRE==0, UCPREN=1, MODE=OPWFM */  
  /* Next line done for test purposes to observe PWM signal */
  SIU.PCR[117].R = 0x0A00;          /* Port PJ12: eMIOS (opt.2), output */ 

  /* eMIOS 1 chan 18:  Provide amplitude to SGL Mux B */
  EMIOS_1.CH[18].CADR.R = 5;       /* Count n eMIOS clocks for OWPFMB duty cycle */
  EMIOS_1.CH[18].CBDR.R = 10;      /* Count n eMIOS clocks for OWPFMB period */
  EMIOS_1.CH[18].CCR.R= 0x02000058; /* UCPRE==0, UCPREN=1, MODE=OPWFM */  
  /* Next line done for test purposes to observe PWM signal */
  SIU.PCR[51].R = 0x0E00;          /* Port PD5: eMIOS (opt.e), output */ 
                                   /* Start eMIOS_1 */
  EMIOS_1.MCR.B.GPRE = 63;         /* eMIOS clk = 64 MHz / (n+1) = 1 MHz */
  EMIOS_1.MCR.B.GPREN = 1;         /* enable prescaler and eMIOS clock */
}

void initSGL_mono(void) {
  SGL.MODE_SEL.B.M_P = 1;          /* Select monotonic sound */
  SGL.MODE_SEL.B.PRE = 0;          /* Prescale 64 MHz clock by 1 */
  SGL.MODE_SEL.B.CH1_SEL = 0x9;    /* Select EMIOS_1 ch 17: 1KHz, 50% duty */
  SGL.MODE_SEL.B.CH2_SEL = 0xA;    /* Select EMIOS_1 ch 18: 2KHz, 50% duty */
  SGL.MODE_SEL.B.SOUND_CTRL = 0;   /* Sound control: No sound (reset default) */
  SIU.PCR[40].R = 0x0A00;          /* Port PC10: SGL (opt. 2) output */
  /* The following two lines apply if using Freescale MPC5606S_DEMO_V2 EVB: */
  SIU.PCR[43].R = 0x0200;          /* Port PC13: GPIO output for BATT switch */
  SIU.GPDO[43].R = 1;              /* Enable BATT switch to speaker circuit */
}

void SGL_mono_cont(void){          /* MODE 2 */
  SGL.MODE_SEL.B.SOUND_CTRL = 2;   /* Sound control: enable continuous sound */
  for (j=0; j<10000000; j++)  {}   /* Delay, then exit mode 2 */
  SGL.SOUND_DURATION.R = 2;        /* Duration: set >1 to enable SDCIF flag */     
  SGL.MODE_SEL.B.SOUND_CTRL = 1;   /* Sound ctrl: expire DURATION to set flag */
  SGL.MODE_SEL.B.SOUND_CTRL = 0;   /* Sound ctrl: no sound, enable clearing flag */    
  SGL.SGL_STATUS.R = 0x00000001;   /* Clear flag */
}

void SGL_mono_cont_duration(void){   /* MODE 1 multiple cases */

      /* 1st duration:  1 second at current frequency, duty cycle */
  SGL.SOUND_DURATION.R = 64000000;   /* Duration: # of SGLclks (1 sec) */     
  SGL.MODE_SEL.B.SOUND_CTRL = 1;     /* Sound ctrl: continuous sound with duration*/
  while (!SGL.SGL_STATUS.B.SDCIF) {} /* Wait for flag */
  SGL.MODE_SEL.B.SOUND_CTRL = 0;     /* Sound ctrl: no sound, enable clearing flag */ 
  SGL.SGL_STATUS.R = 0x00000001;     /* Clear flag */

      /* 2nd duration: change audio frequency(Mux A PWM frequency with fixed duty) */
  EMIOS_1.OUDR.B.OU17 = 1;           /* Disable emios1 ch 17 for updating data regs */
  EMIOS_1.CH[17].CBDR.R = 2000;      /* Mux A period:  set to 2000 eMIOS clks */  
  EMIOS_1.CH[17].CADR.R = 1000;      /* Mux A duty cycle: keep at 50% */
  EMIOS_1.OUDR.B.OU17 = 0;           /* Re-enable emios 1 chan 17  */  
  SGL.MODE_SEL.B.SOUND_CTRL = 1;     /* Sound ctrl: continuous sound with duration*/
  while (!SGL.SGL_STATUS.B.SDCIF) {} /* Wait for flag */
  SGL.MODE_SEL.B.SOUND_CTRL = 0;     /* Sound ctrl: no sound, enable clearing flag */    
  SGL.SGL_STATUS.R = 0x00000001;     /* Clear flag */

      /* 3rd duration: change amplitude (Mux B PWM duty cycle) */
  EMIOS_1.CH[18].CADR.R = 3;         /* Mux B duty: change from 5 to 3 */  
  SGL.MODE_SEL.B.SOUND_CTRL = 1;     /* Sound ctrl: continuous sound with duration*/
  while (!SGL.SGL_STATUS.B.SDCIF) {} /* Wait for flag */
  SGL.MODE_SEL.B.SOUND_CTRL = 0;     /* Sound ctrl: no sound gen, enable clearing flag */    
  SGL.SGL_STATUS.R = 0x00000001;     /* Clear flag */
}

void SGL_mono_periodic_duration(void){ /* MODE 5 */
  SGL.SOUND_DURATION.R = 128000000;  /* Duration:    # of SGL clks (2 sec) */
  SGL.HIGH_PERIOD.R    =   8000000;  /* High period: # of SGL clks (1/8 sec) */     
  SGL.LOW_PERIOD.R     =  24000000;  /* High period: # of SGL clks (3/8 sec) */     
  SGL.MODE_SEL.B.SOUND_CTRL = 5;     /* Sound ctrl: cont. sound with duration & periods */
  while (!SGL.SGL_STATUS.B.SDCIF) {} /* Wait for flag */
  SGL.MODE_SEL.B.SOUND_CTRL = 0;     /* Sound ctrl: no sound, enable clearing flag */    
  SGL.SGL_STATUS.R = 0x00000001;     /* Clear flag */
}

void SGL_mono_periodic(void){        /* MODE 6 */
  SGL.HIGH_PERIOD.R    =   4000000;  /* High period: # of SGL clks (1/16 sec) */     
  SGL.LOW_PERIOD.R     =  12000000;  /* High period: # of SGL clks (3/16 sec) */     
  SGL.MODE_SEL.B.SOUND_CTRL = 6;     /* Sound ctrl: cont. sound with periods */
  for (j=0; j<10000000; j++)  {}     /* Delay then exit mode 6 */
  SGL.SOUND_DURATION.R = 2;          /* Duration: set >1 to enable SDCIF flag */     
  SGL.MODE_SEL.B.SOUND_CTRL = 1;     /* Sound control: expire DURATION to set flag */
  SGL.MODE_SEL.B.SOUND_CTRL = 0;     /* Sound ctrl: no sound, enable clearing flag */    
  SGL.SGL_STATUS.R = 0x00000001;     /* Clear flag */
}

void main (void) {	 
  initModesAndClock();         /* Initialize mode entries and system clock */
  initPeriClkGen();            /* Generate peripheral clock to SGL, other set 1 peris */
  disableWatchdog();           /* Disable watchdog */
  initEMIOS_1();               /* Initialize eMIOS 1 channels 17 & 18 */
  initSGL_mono();              /* Init SGL: Mono, no sound, prescale by 1, emios1 ch 17, 18 */

  SGL_mono_cont();             /* Generate a mono sound, continuous */
  for (j=0; j<5000000; j++){}  /* Delay between sounds */
  SGL_mono_cont_duration();    /* Generate different mono sounds, cont. with duration */
  for (j=0; j<5000000; j++){}  /* Delay between sounds */
  SGL_mono_periodic_duration();/* Generate mono sound, periodic with duration */
  for (j=0; j<5000000; j++){}  /* Delay between sounds */
  SGL_mono_periodic();         /* Generate mono sound, no duration */

  while (1) { 
  	i++;
  }	
}
