# ivor_branch_table_and_vector_init_VLE.s - use with e200z0, e200z1 cores using VLE
# Description:  Branch table for 16 core interrupts
#               and initialization code for IVPR (initIrqVectors)
# Copyright Freescale 2007.  All Rights Reserved
# Rev 1.0 Jul 6 2007 S Mihalik - Initial version 
# Rev 1.1 Aug 30 2007 SM - Made IVOR4Handler extern
# Rev 1.2 Sep 9 2008 SM - Converted assembly to VLE syntax
# Rev 1.3 Feb 9 2011 SM - moved initIrqVectors from main.c, added comments

  .extern IVOR4Handler
  .extern __IVPR_VALUE
	
  .globl initIrqVectors  
	
  .equ SIXTEEN_BYTES, 16   # 16 byte alignment required for table entries 
                             # Diab compiler uses value of 4 (2**4=16)
							 # CodeWarrior, GHS, Cygnus use 16
							 
############## IVOR Branch Table  ########################

# Use one of the next two lines for proper location of interrupt tables:
  .section .ivor_branch_table,text_vle # Use for e200z0, e200z1 cores
# .section .text_vle                   # Use for e200z3 and higher cores                   

				.align SIXTEEN_BYTES       
IVOR0trap:  e_b	IVOR0trap	 # IVOR 0 interrupt handler (Critical Interrupt)

				.align SIXTEEN_BYTES       
IVOR1trap:  e_b	IVOR1trap	 # IVOR 1 interrupt handler (Machine Check)
						
				.align SIXTEEN_BYTES       
IVOR2trap:  e_b	IVOR2trap	 # IVOR 2 interrupt handler (Data Storage)

				.align SIXTEEN_BYTES       
IVOR3trap:  e_b	IVOR3trap	 # IVOR 3 interrupt handler (Instruction Storage)

				.align SIXTEEN_BYTES       
            e_b IVOR4Handler # IVOR 4 interrupt handler (External Interrupt)

				.align SIXTEEN_BYTES       
IVOR5trap:  e_b	IVOR5trap    # IVOR 5 interrupt handler (Alignment)

				.align SIXTEEN_BYTES       
IVOR6trap:  e_b	IVOR6trap	 # IVOR 6 interrupt handler (Program)

				.align SIXTEEN_BYTES       
IVOR7trap:  e_b	IVOR7trap	 # IVOR 7 interrupt handler (Float Pt Unavail)

				.align SIXTEEN_BYTES       
IVOR8trap:  e_b	IVOR8trap	 # IVOR 8 interrupt handler (System Call)

				.align SIXTEEN_BYTES       
IVOR9trap:  e_b	IVOR9trap	 # IVOR 9 interrupt handler (AP Unavail)

				.align SIXTEEN_BYTES       
IVOR10trap: e_b IVOR10trap   # IVOR 10 interrupt handler (Decrementer)

				.align SIXTEEN_BYTES       
IVOR11trap: e_b	IVOR11trap	 # IVOR 11 interrupt handler (Fixed Interval Timer)

				.align SIXTEEN_BYTES       
IVOR12trap: e_b	IVOR12trap	 # IVOR 12 interrupt handler (Watchdog Timer)

				.align SIXTEEN_BYTES       
IVOR13trap: e_b	IVOR13trap	 # IVOR 13 interrupt handler (Data TLB Error)

				.align SIXTEEN_BYTES       
IVOR14trap: e_b	IVOR14trap	 # IVOR 14 interrupt handler (Instr TLB Error)

				.align SIXTEEN_BYTES       
IVOR15trap: e_b	IVOR15trap	 # IVOR15 interrupt handler (Debug)


############## Initialize Interrupt Vector(s)  ########################

  .section .text_vle

initIrqVectors:   # Initialize spr IVPR (Interrupt Vector Prefix Reg)
				  # Function is called from C, hence r3 (volatile reg)
				  # does not need to be preserved on stack	 
				  
  e_lis	   r3, __IVPR_VALUE@h   # __IVPR_VALUE is passed from linker
  e_or2i   r3, __IVPR_VALUE@l 
  mtivpr   r3
  se_blr									 

