#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */
#include "mcu.h"

char pdb1_cont_times = 0;


void main(void) {
  //EnableInterrupts;
  /* include your code here */

  mcu_init();
#if defined _PDB_RTC_PDB1_
  rtc_init();
#elif defined _PDB_FTM_TR_ADC_
  ftm1_init();
  adc_init();
#ifdef _PDB_FTM_PGA_ADC_
  pga_init();
#endif
#elif defined _PDB_HSCMP_ADC_
  hscmp1_init();
  adc_init();
#elif defined _FTM1_PDB2_HSCMP1_PDB1_ADC_
  ftm1_init();
  pdb2_init();
  hscmp1_init();
  adc_init();
#endif	
  pdb1_init();

  
  pdb1_cont_times = 0;
  PTDD_PTDD3 = 0;

  EnableInterrupts;
  for(;;) {
    __RESET_WATCHDOG();	/* feeds the dog */
  } /* loop forever */
  /* please make sure that you never leave main */
}

void interrupt rtc_isr(void){
	PTDD_PTDD3 ^= 1;
	RTCSC_RTIF = 1;		/* Clear RTC interrupt */
}

void interrupt pdb1_isr(){
	if(PDB1SCR_COF == 1){ 
		PDB1SCR_COF = 1;
		if(PDB1CTRL2_CONT)
		{
			if(++pdb1_cont_times >= 5)
			{
				PDB1CTRL2_CONT = 0;	//Disable continuous mode
				pdb1_cont_times =0;
			}
		}else
		{
			PDB1CTRL2_CONT = 1;
			pdb1_cont_times = 0;
		}
	}
	if(PDB1SCR_DAF == 1) 
		PDB1SCR_DAF = 1;
	if(PDB1SCR_DBF == 1) 
		PDB1SCR_DBF = 1;
}

void interrupt adc_isr(void){
	PTDD_PTDD3 = 1;
	asm nop;
	asm nop;
	PTDD_PTDD3 = 0;
	
	ADCRL;
}

void interrupt ftm1_tof_isr(void){
	FTM1SC;
	FTM1SC_TOF = 0;
	PTDD_PTDD1 = 1;
	asm nop;
	asm nop;
	PTDD_PTDD1 = 0;
}

void interrupt ftm1_ch0f_isr(void){
	FTM1C0SC;
	FTM1C0SC_CH0F = 0;
	PTDD_PTDD1 = 1;
	asm nop;
	asm nop;
	PTDD_PTDD1 = 0;
}
