/*****************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2004-2005 Freescale Semiconductor, Inc.
* (c) Copyright 2001-2004 Motorola, Inc.
* ALL RIGHTS RESERVED.
*
******************************************************************************
*
* File Name: uccp_ucan.h
*
* Description: uCCP driver for uCAN private .h - USED INTERNALLY BY THE DRIVER
*
* $Version: 2.0.12.0$
*
*****************************************************************************/

#ifndef __UCCP_UCAN_H
#define __UCCP_UCAN_H

#ifndef __UCCP_CFG_H
#error uCAN: uccp_cfg.h must be included before uccp_ucan.h
#endif

/********************************************************************************************
*
* Private type
*
*********************************************************************************************/

// CAN frame data
typedef union
{
	UWord32 dw[2];
	UWord16 w[4];
	UWord8  b[8];
	
	struct {
		UWord32 dw0;
		UWord32 dw1;
	};

	struct {
		UWord16 w0;
		UWord16 w1;
		UWord16 w2;
		UWord16 w3;
	};
		
} UCCP_DATABUFF;

/********************************************************************************************
*
* Private macros
*
*********************************************************************************************/

// parsing received data
#define PARSE_CRO_CMD(data) data.b[0]
#define PARSE_CRO_CTR(data) data.b[1]

// parsing received data (each command)
#define PARSE_CONNECT_ECU(data) data.w1

#define PARSE_TEST_ECU(data) data.w1

#define PARSE_DISCONNECT_ECU(data) data.w2
#define PARSE_DISCONNECT_EOS(data) data.b[2]

#define PARSE_SETMTA_NUM(data) data.b[2]
#define PARSE_SETMTA_EXT(data) data.b[3]
#define PARSE_SETMTA_ADDR(data) data.dw1

#define PARSE_UPLOAD_LEN(data) data.b[2]

#define PARSE_SHORTUP_LEN(data) data.b[2]
#define PARSE_SHORTUP_EXT(data) data.b[3]
#define PARSE_SHORTUP_ADDR(data) data.dw1

#define PARSE_ACTIONSERVICE_NUM(data) data.w1
#define PARSE_DIAGSERVICE_NUM(data) data.w1

// building response words
#define MAKEWORD(lo,hi) ((((hi) << 8) & 0xff00) | ((lo) & 0xff))

// get UWord32 byte address of structures or 16/32-bit variables
#define GETBYTEADDR(ptr) (2 * ((UWord32)(UWord16*)(ptr)))

/********************************************************************************************
*
* Private constants
*
*********************************************************************************************/

// CCP 2.1 implemented here
#define UCCP_VER_MAJOR 2
#define UCCP_VER_MINOR 1

#define UUCP_RES_AM 0
#define UUCP_RES_PM 0

// CCP command numbers
#define CCP_CONNECT           0x01
#define CCP_SET_MTA           0x02
#define CCP_DNLOAD            0x03
#define CCP_UPLOAD            0x04
#define CCP_TEST              0x05 /* V2.1 */
#define CCP_START_STOP        0x06
#define CCP_DISCONNECT        0x07
#define CCP_START_STOP_ALL    0x08 /* V2.1 */
#define CCP_SHORT_UP          0x0F
#define CCP_GET_DAQ_SIZE      0x14
#define CCP_SET_DAQ_PTR       0x15
#define CCP_WRITE_DAQ         0x16
#define CCP_EXCHANGE_ID       0x17
#define CCP_GET_CCP_VERSION   0x1B /* V2.1 */
#define CCP_DNLOAD6           0x23
#define CCP_GET_CAL_PAGE      0x09
#define CCP_SET_S_STATUS      0x0C
#define CCP_GET_S_STATUS      0x0D
#define CCP_BUILD_CHKSUM      0x0E
#define CCP_CLEAR_MEMORY      0x10
#define CCP_SET_CAL_PAGE      0x11
#define CCP_GET_SEED          0x12
#define CCP_UNLOCK            0x13
#define CCP_PROGRAM           0x18
#define CCP_MOVE_MEMORY       0x19
#define CCP_DIAG_SERVICE      0x20
#define CCP_ACTION_SERVICE    0x21
#define CCP_PROGRAM6          0x22

/* CCP return codes */
#define CRC_OK                 0x00

/* C1 */
#define CRC_CMD_BUSY           0x10
#define CRC_DAQ_BUSY           0x11
#define CRC_KEY_REQUEST        0x18
#define CRC_STATUS_REQUEST     0x19

/* C2 */
#define CRC_COLD_START_REQUEST 0x20
#define CRC_CAL_INIT_REQUEST   0x21
#define CRC_DAQ_INIT_REQUEST   0x22
#define CRC_CODE_REQUEST       0x23

/* C3 Errors */
#define CRC_CMD_UNKNOWN        0x30
#define CRC_CMD_SYNTAX         0x31
#define CRC_OUT_OF_RANGE       0x32
#define CRC_ACCESS_DENIED      0x33
#define CRC_OVERLOAD           0x34
#define CRC_ACCESS_LOCKED      0x35
#define CRC_RESOURCE_NOT_AVAIL 0x36

// specific command parameter constants

// CCP_SET_MTA number
#define CCP_SETMTA_NUM_STANDARD 0x00
#define CCP_SETMTA_NUM_MOVE 	0x01

/********************************************************************************************
*
* Private function prototypes & inline functions
*
*********************************************************************************************/

Word16 UCCP_FindFreeServiceIx(UCCP_SERVICE_CALLBACK* list, UWord16 count);
Word16 UCCP_FindServiceById(UWord16 id, UWord16* list, UWord16 count);
void UCCP_RxCallback(UWord16 bNum);
void UCCP_TxCallback(UWord16 bNum);

#endif /* __UCCP_UCAN_H */
