/*****************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2004-2007 Freescale Semiconductor, Inc.
* (c) Copyright 2001-2004 Motorola, Inc.
* ALL RIGHTS RESERVED.
*
******************************************************************************
*
* File Name: ucan_ms.h
*
* Description: msCAN specific operation of the uCAN driver
*
* $Version: 1.0.13.0$
*
*****************************************************************************/

#ifndef __UCAN_MS_H
#define __UCAN_MS_H

#ifndef __UCAN_H
#error uCAN: do not include the ucan_ms.h directly (include ucan.h instead)
#endif

// we need mscan low-level driver here because some inline functions need it
#include "mscan.h"

/********************************************************************************************
* uCAN-MSCAN specific data types
*********************************************************************************************/

// Message Buffer structure (sizeof()==8 !)

typedef struct
{
	UWord16 csw;		// control & status word (State+Length)
	UWord16 data[4];	// 8 bytes of data
	UWord16 timeStamp;	// timestamp (if used)
	UWord32 idr;		// IDR (four 8-bit IDRs concated)
		
} UCAN_MSGBUFFER;

/********************************************************************************************
* uCAN-MSCAN private data
*********************************************************************************************/

extern UCAN_MSGBUFFER ucan_msgBuff[];
extern UWord32 ucan_rxlistenMask;
extern UWord32 ucan_txreadyMask;

/********************************************************************************************
* uCAN-MSCAN-specific macros
*********************************************************************************************/

// internal buffer states
#define UCANB_VOID 		0x00		// buffer void
#define UCANB_RXEMPTY 	0x04		// active and empty
#define UCANB_RXFULL	0x02		// filled with received data
#define UCANB_RXOVERRUN	0x06		// receiver overrun (last data)
#define UCANB_TXONCE	0x0c		// queued for transmission, once
#define UCANB_TXRALWAYS	0x0a		// transmit response to RTR always

#define UCANB_RXOLD_FLAG	0x10	// temporary bit for CheckStatusMB (see there)
#define UCANB_NOTXCB_FLAG	0x20	// temporary bit to avoid callback after RTR-TX (see TxISR)

// MB parsing 
#define UCAN_MB_GET_STATE(pmb) 	      \
	((pmb)->csw & 0xf)
	
#define UCAN_MB_SET_STATE(pmb, code)  \
	{ register UWord16 __tmp = (pmb)->csw;	\
	  __tmp &= ~0xf, __tmp |= code;	\
	  (pmb)->csw = __tmp; }
	  
#define UCAN_MB_GET_LENGTH(pmb)       (((pmb)->csw >> 8) & 0xf)
#define UCAN_MB_SET_LENGTH(pmb, len)  ((pmb)->csw &= ~0xf00, (pmb)->csw |= (len) << 8)

/********************************************************************************************
* Internal function prototypes
*********************************************************************************************/

void UCAN_Copy(register UWord16* psrcBuff, register UWord16* pdestBuff);
void UCAN_CopySwab(register UWord16* psrcBuff, register UWord16* pdestBuff);
void UCAN_CopySplit(register UWord16* psrcBuff, register UWord16* pdestBuff);
void UCAN_CopyBuild(register UWord16* psrcBuff, register UWord16* pdestBuff);

/************************************************************
*  define "assert" macro for selected paranoia level
************************************************************/

#if UCAN_DEBUG == 0
#define UCAN_ASSERT(cond, retcode) /* empty */
#elif UCAN_DEBUG == 1
#define UCAN_ASSERT(cond, retcode) if(!(cond)) return retcode
#else
#define UCAN_ASSERT(cond, retcode) if(!(cond)) { archDebugHalt(); return retcode; }
#endif

/****************************************************************************
* Configuration Checks and default values
*****************************************************************************/

#ifndef UCAN_MODULE
#define UCAN_MODULE MSCAN
#endif

#ifndef UCAN_MSGBUFF_COUNT
#define UCAN_MSGBUFF_COUNT 16
#endif

#ifndef UCAN_MSGBUFFEX_COUNT
#define UCAN_MSGBUFFEX_COUNT 2
#endif

#if UCAN_MSGBUFFEX_COUNT > UCAN_MSGBUFF_COUNT
#error uCAN: The UCAN_MSGBUFFEX_COUNT must be less than or equal to UCAN_MSGBUFF_COUNT in ucan_cfg.h
#endif 

#ifndef UCAN_DATA_LSBFIRST
#define UCAN_DATA_LSBFIRST 0
#endif

/****************************************************************************
* Inline Functions
*****************************************************************************/




#endif /* __UCAN_MS_H */

