/******************************************************************************
*
* Motorola Inc.
* (c) Copyright 2002 Motorola, Inc.
* ALL RIGHTS RESERVED.
*
*******************************************************************************/


#ifndef _TM_CYCLECNT_H_
#define _TM_CYCLECNT_H_


#ifdef __cplusplus
extern "C" {
#endif


#ifdef TM_BOARD_DAKARLITE
    #ifdef TM_BOARD_WEDGE
        #error "Multiple boards defined!"
    #endif

// ************************************* DAKARLITE *************************************
#define TM_START_TIMERA0	periphMemWrite(0x0000,&ArchIO.TimerA.Channel0.ControlReg);\
							periphMemWrite(0x0000,&ArchIO.TimerA.Channel0.StatusControlReg);\
            				periphMemWrite(0x0000,&ArchIO.TimerA.Channel0.CounterReg);\
			            	periphMemWrite(0x3000,&ArchIO.TimerA.Channel0.ControlReg);
#define TM_STOP_TIMERA0	(periphMemWrite(0x0000,&ArchIO.TimerA.Channel0.ControlReg));
#define TM_READ_TIMERA0	 (periphMemRead(&ArchIO.TimerA.Channel0.CounterReg))  


// ************************************* WEDGE *************************************
#elif defined(TM_BOARD_WEDGE)

#define TMR_BASE      (UWord16 *)0x1FFE80
#define TMR_CTRL_ADDR (UWord16 *)0x1FFE86
#define TMR_STCT_ADDR (UWord16 *)0x1FFE87
#define TMR_CNTR_ADDR (UWord16 *)0x1FFE85

#define TM_START_TIMERA0	periphMemWrite(0x0000,TMR_CTRL_ADDR);\
							periphMemWrite(0x0000,TMR_STCT_ADDR);\
				            periphMemWrite(0x0000,TMR_CNTR_ADDR);\
				            periphMemWrite(0x3000,TMR_CTRL_ADDR);

#define TM_STOP_TIMERA0	(periphMemWrite(0x0000,TMR_CTRL_ADDR));
#define TM_READ_TIMERA0	 (periphMemRead(TMR_CNTR_ADDR))  

// ************************************* MONZA *************************************
#elif defined(TM_BOARD_MONZA)

#define TMR_BASE      (UWord16 *)0x1FFE80
#define TMR_CTRL_ADDR (UWord16 *)0x1FFE86
#define TMR_STCT_ADDR (UWord16 *)0x1FFE87
#define TMR_CNTR_ADDR (UWord16 *)0x1FFE85

#define TM_START_TIMERA0	periphMemWrite(0x0000,TMR_CTRL_ADDR);\
							periphMemWrite(0x0000,TMR_STCT_ADDR);\
				            periphMemWrite(0x0000,TMR_CNTR_ADDR);\
				            periphMemWrite(0x3000,TMR_CTRL_ADDR);

#define TM_STOP_TIMERA0	(periphMemWrite(0x0000,TMR_CTRL_ADDR));
#define TM_READ_TIMERA0	 (periphMemRead(TMR_CNTR_ADDR))

// *********************************************************************************
#else
#error "Board not defined!"
#endif

#ifdef __cplusplus
}
#endif


#endif /* _TM_CYCLECNT_H_ */
