;  Metrowerks Embedded Runtime Support 1998 May 
;
;	console.asm
;	
; 		Copyright  1998 Metrowerks, Inc.
; 		All rights reserved.
;       Modified by MCSL 2002 for testman.
;
; 	Routines
; 	--------
; 		F_tm__console_write
;		Ftm_fflush_console
;		F_tm__dbg_put_char
; 

bufsiz		equ	80	; size of output buffer
newln		equ	$0A	; ASCII for '\n'
lnfeed		equ $0D ; ASCII for '\r'
	section		rtlib
	org	x:

;
; Data buffers
;

STDOUTBufferCount: 	dc	0
STDINBufferCount:	dc 	0

	org	xl:
STDOUTBuffer:		ds	bufsiz
STDINBuffer:		ds	bufsiz
 	
	org p:
 	
;-------------------------------------------------------------------
; F_tm_console_write - When the console buffer is flushed
;                   this routine will be called. From here, we will
;					hault the process and print the buffer to the
;					debugger window
;
; Inputs: 	X0 - Number of words to write
;			R2 - Pointer to buffer
;
; Debugger Inteface:  	R3 - Number of words to write
;           			R2 - Buffer
;           			__stdout is 1
;						debug hit
;--------------------------------------------------------------------

	global F_tm__console_write
	SUBROUTINE "F_tm__console_write",F_tm__console_write,F_tm__console_writeEND-F_tm__console_write
 F_tm__console_write:
	move.w	X0,R3
	
	move.w	#1,R1			
	move.w	R1,x:F__stdout_ready	; LMM
	nop
 	debughlt
	move.w	#0,R1			
	move.w	R1,x:F__stdout_ready	; LMM
	nop

 	rts
 F_tm__console_writeEND:
 
;-------------------------------------------------------------------
; tm_fflush_console( ) - move the output buffer to the console
;
; Parameters:
;	none
;-------------------------------------------------------------------
	global	Ftm_fflush_console
	SUBROUTINE "Ftm_fflush_console",Ftm_fflush_console,Ftm_fflush_consoleEND-Ftm_fflush_console
Ftm_fflush_console:
	move.l	#STDOUTBuffer,r2		;LMM
	move.w	x:STDOUTBufferCount,x0	;LMM number of characters in buffer
	cmp.w	#0,x0
	bgt		flush_buf
	nop
	nop
	rts
Ftm_fflush_consoleEND:

;-------------------------------------------------------------------
; F_tm__dbg_put_char( int c )  - print a character to stdout
;
; Parameters:
;  c		passed in y0
;
;-------------------------------------------------------------------
	global	F_tm__dbg_put_char
	SUBROUTINE "F_tm__dbg_put_char",F_tm__dbg_put_char,F_tm__dbg_put_charEND-F_tm__dbg_put_char
F_tm__dbg_put_char:
	cmp.w	#newln,y0				; is char a '\n'
	bne		not_newln				; if no, skip conversion
	move.w	#$0d,y0					; if yes, convert it to a line feed
not_newln:
	move.l	#STDOUTBuffer,r2		; LMM
	move.w	x:STDOUTBufferCount,x0	; LMM get # words in buffer
	move.w	x0,n
	move.w	y0,x:(r2+n)				; store char
	move.w	n,x0
	inc.w	x0		 				; increment word count
	cmp.w	#lnfeed,y0				; is char a '\r'
	beq		flush_buf				; if yes, flush
	cmp.w	#bufsiz,x0				; is buffer full?
	blt		putc_branch1
flush_buf:
									; address of buffer in r2
									; Count in X0
	jsr	F_tm__console_write			; output via debugger interface
	move.w 	#0,x0					; clear buffer count	
putc_branch1:
	move.w	x0,x:STDOUTBufferCount	; LMM
	rts 	
F_tm__dbg_put_charEND:	
	
	
 	
 	endsec