#ifndef _TESTMAN_H_
#define _TESTMAN_H_

/* #include "port.h" */

#ifndef true
#define true (1)
#endif

#ifndef false
#define false (0)
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*****************************************************************************
* printf removed in order to allow the test applications to use internal memory,
* the reason: printf function need too much resources
*****************************************************************************/

#define TEST_NO_PRINTF
/*
#undef TEST_NO_PRINTF
*/

/*****************************************************************************
*
* TM_MINOVERHEAD
*   In order to minimize the overhead of calling testman function the macro,
*   the macro should be defined. This will disable any testman calls except
*   the testCycleReport() and measurement routines.
*
* TM_BOARD_DAKARLITE
*   The macro should be defined if Dakar Lite board is used.
*
* TM_BOARD_WEDGE
*   The macro should be defined if Wedge board is used.
*
* If both TM_BOARD_DAKARLITE and TM_BOARD_WEDGE are defined then
* the TM_BOARD_DAKARLITE takes precedence. If none are defined,
* an error is reported.
*
*****************************************************************************/

/*****************************************************************************
*
* The macros below can be defined directly in this file or (better) in tm_config.h
* header file.
*
*****************************************************************************/

/*#define TM_MINOVERHEAD*/
/*#define TM_BOARD_WEDGE*/
/*#define TM_BOARD_DAKARLITE*/

/*******************************************************
* Test Package
*******************************************************/

#define TEST_NAME_MAX_LEN 60

typedef struct {
	short  passed;
	short  completed;
	char  name[TEST_NAME_MAX_LEN];
} test_sRec;

extern void    testStart   (test_sRec *pTest, const char *pName);

extern void    testFailed  (test_sRec *pTest, const char *pMsg);

extern void    testComment (test_sRec *pTest, const char *pMsg);

extern void    testEnd     (test_sRec *pTest);

extern void    testPrintString (const char *pMsg);

extern short   testCompareNum(long int a, long int b, long int tolerance);

extern void tmCountCalc(unsigned long *const pExecTime,
				int n,
				unsigned long *const pAvr,
				unsigned long *const pMax, 
				unsigned long *const pMin
				);
extern void tmCountReport(unsigned long AvrExecTime, 
				unsigned long MaxExecTime, 
				unsigned long MinExecTime);

#ifdef __cplusplus
}
#endif

#endif /* _TESTMAN_H_ */