/*******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2004 Freescale Semiconductor, Inc.
* (c) Copyright 2001-2004 Motorola, Inc.
* ALL RIGHTS RESERVED.
*
********************************************************************************
*
* FILE NAME: testman.c
*
* Description: 
*
*******************************************************************************/

#include <stdio.h>
#include <string.h>
#include "types.h"
#include "testman.h"

#define archDisableInt() asm(bfclr #0x0300,SR);
#define archEnableInt() asm(bfset #0x0300,SR);


/*******************************************************
* Test Package
*******************************************************/

#ifndef TEST_NO_PRINTF

void    testStart  (test_sRec *pTest, const char *pName)
{
	pTest -> passed    = true;
	pTest -> completed = false;

	strncpy (pTest -> name, pName, TEST_NAME_MAX_LEN);
	pTest -> name[TEST_NAME_MAX_LEN - 1] = 0;
	archDisableInt();
	printf("%s - Started\n", pName);
	archEnableInt();
}


void    testFailed (test_sRec *pTest, const char *pMsg)
{
	pTest -> passed = false;

	archDisableInt();
	printf("%s - !!! Failed !!! %s\n", pTest -> name, pMsg);
	archEnableInt();
}


void    testComment (test_sRec *pTest, const char *pMsg)
{
	archDisableInt();
	printf("%s - %s\n", pTest -> name, pMsg);
	archEnableInt();
}


void    testEnd (test_sRec *pTest)
{
	pTest -> completed = true;

	archDisableInt();
	if (pTest -> passed) 
	{
		printf("%s - Passed\n", pTest -> name);
		printf("%s - Ended\n",  pTest -> name);
	} 
	else 
	{
		printf("%s - Ended\n", pTest -> name);
	}
	archEnableInt();
}

void testPrintString( const char *pMsg)
{
	archDisableInt();
	printf("%s", pMsg);
	archEnableInt();
}

#else /* TEST_NO_PRINTF */

/*******************************************************************************
*
* NAME: testStart
*
* DESCRIPTION: Prepare test record and print message that test started
*
********************************************************************************
* PARAMETERS:  Test record and name of test
*
*******************************************************************************/
void    testStart  (test_sRec *pTest, const char *pName)
{
	pTest -> passed    = true;
	pTest -> completed = false;

	strncpy (pTest -> name, pName, TEST_NAME_MAX_LEN);
	pTest -> name[TEST_NAME_MAX_LEN - 1] = 0;
	testPrintString(pName);
	testPrintString(" - Started\n");
}


/*******************************************************************************
*
* NAME: testFailed
*
* DESCRIPTION: Print message that test failed
*
********************************************************************************
* PARAMETERS:  Test record and error message
*
*******************************************************************************/
void    testFailed (test_sRec *pTest, const char *pMsg)
{
	pTest -> passed = false;

	testPrintString(pTest->name);
	testPrintString(" - !!! Failed !!! ");
	testPrintString( pMsg );
	testPrintString("\n");
}


/*******************************************************************************
*
* NAME: testComment
*
* DESCRIPTION: Print test comment message
*
********************************************************************************
* PARAMETERS:  Test record and comment message
*
*******************************************************************************/
void    testComment (test_sRec *pTest, const char *pMsg)
{
	testPrintString(pTest->name);
	testPrintString(" - ");
	testPrintString(pMsg);
	testPrintString("\n");
}


/*******************************************************************************
*
* NAME: testEnd
*
* DESCRIPTION: Print message that test ended
*
********************************************************************************
* PARAMETERS:  Test record
*
*******************************************************************************/
void    testEnd (test_sRec *pTest)
{
	pTest -> completed = true;

	if (pTest -> passed) 
	{
		testPrintString(pTest->name);
		testPrintString(" - Passed\n");
	}
	testPrintString(pTest->name);
	testPrintString(" - Ended\n");
}


/*******************************************************************************
*
* NAME: testPrintString
*
* DESCRIPTION: Sends string to stdout
*
********************************************************************************
* PARAMETERS:  Message
*
*******************************************************************************/
void * __ConsoleWrite(void *File, const char * Buffer, size_t NumChars);

void testPrintString( const char *pMsg)
{
	/* Use direct assembly instead of macros in order to make the module
	 * self-contained as much as possible
	 */
	/*archDisableInt();*/
	asm(bfclr #0x0300,SR);
	__ConsoleWrite( (void *)stdout, (const char *) pMsg, strlen( pMsg ) );
	/*
	fwrite(pMsg, sizeof(char), strlen(pMsg), stdout);
	*/
	/*archEnableInt();*/
	asm(bfset #0x0300,SR);
}

#endif	/* TEST_NO_PRINTF */

/***************************************************************************
*
*  Function: testCompareNum
*
*  Description: compare two numbers with defined tolerance.
*
*  Arguments:
*		a,b       -(in) compared numbers					
*		tolerance -(in) tolerance
*
*  Returns: boolean variable, true when difference is in tolerance range
*
*  Range Issues: none
*
*  Special Issues: none
*
*****************************************************************************/

/*
short testCompareNum(Frac32 a, Frac32 b, Frac32 tolerance)
*/
short testCompareNum(long int a, long int b, long int tolerance)
{
   /* Frac32 t; */
   long int t;

/*    t = L_abs(a-b);*/
    t = a-b;
    t = (t<0) ? -t:t;
    

    if (t > tolerance)
    {
       return(0);
    }
    else
    {
        return(1);
    }
}

/***************************************/

#define TMR_CTRL_VAL 0x3000

#ifdef TM_NORADEGAST
typedef char           Word8;
typedef unsigned char  UWord8;
typedef short          Word16;
typedef unsigned short UWord16;
typedef long           Word32;
typedef unsigned long  UWord32;

typedef char           Int8;
typedef unsigned char  UInt8;
typedef int            Int16;
typedef unsigned int   UInt16;
typedef long           Int32;
typedef unsigned long  UInt32;
#endif


#define CountReport_BUFFLENGTH 128
/*
void tmCountCalcAndReport(unsigned long *const pExecTime,
				int n,
				int *const pAvr,
				int *const pMax,
				int *const pMin
				)
{
	UWord32 avrExecTime, maxExecTime, minExecTime;
	tmCountCalc(pExecTime, n, &avrExecTime, &maxExecTime, &minExecTime);
	tmCountReport(avrExecTime, maxExecTime, minExecTime);

	return;
}  */


void tmCountCalc(unsigned long *const pExecTime,
				int n,
				UWord32 *const pAvr,
				UWord32 *const pMax,
				UWord32 *const pMin
				)
{
	unsigned int i;
	unsigned int k;
	UWord32 maxExecTime, minExecTime;
	UWord32 sum;
	

	sum=0;
	maxExecTime=0;
	minExecTime=0xFFFFFFFF;

	for(i=0;i<n;i++)
	{
		sum = sum + pExecTime[i];

		if (maxExecTime<pExecTime[i])
		{
			maxExecTime=pExecTime[i];
		}

		if (minExecTime>pExecTime[i])
		{
			minExecTime=pExecTime[i];
		}
		

	}
	sum=sum/n; 

	(*pMax) = maxExecTime;
	(*pMin) = minExecTime;
	(*pAvr) = sum;
	
	return;
}

void tmCountReport(unsigned long AvrExecTime, unsigned long MaxExecTime, unsigned long MinExecTime)
{
	char sBuffer[128];	/* Buffer to keep string for console */
#ifdef TEST_NO_PRINTF
   /* NOTE: The length of the message should not exceed the
    *       buffer size defined above.
    */
   sprintf(sBuffer,"AVG CYCLE COUNT: %lu\n", AvrExecTime);
   testPrintString(sBuffer);

   sprintf(sBuffer,"MAX CYCLE COUNT: %lu\n", MaxExecTime);
   testPrintString(sBuffer);

   sprintf(sBuffer,"MIN CYCLE COUNT: %lu\n", MinExecTime);
   testPrintString(sBuffer);
#else
	printf("%s%lu \n", "AVG CYCLE COUNT: ", AvrExecTime);	
	printf("%s%lu \n", "MAX CYCLE COUNT: ", MaxExecTime );
	printf("%s%lu \n", "MIN CYCLE COUNT: ", MinExecTime ); 
#endif

	return;
}

