/*******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2004-2010 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
********************************************************************************
*
* File Name:  sys.c
*
* $Date:      Oct-12-2010$
*
* $Version:   2.5.4.0$
*
* Description: SYS (system reset and support functions) driver SIM_VERSION_6
*
*****************************************************************************/

#include "qs.h"
#include "sys.h"

#ifdef __cplusplus
extern "C" {
#endif

/* initialization of SYS (SIM) system support functions */

void sysInit(arch_sSIM *pSimBase)
{
#pragma unused(pSimBase)

	#ifdef SIM_CONROL_INIT
	periphMemWrite(SIM_CONROL_INIT, &pSimBase->sim_control);
	#endif
 
	#ifdef SIM_CLKOSR_INIT
	periphMemWrite(SIM_CLKOSR_INIT, &pSimBase->sim_clkosr);
	#endif

	#ifdef SIM_GPS0_INIT
	periphMemWrite(SIM_GPS0_INIT, &pSimBase->sim_gps0);
	#endif

	#ifdef SIM_GPS1_INIT
	periphMemWrite(SIM_GPS1_INIT, &pSimBase->sim_gps1);
	#endif

	#ifdef SIM_GPS2_INIT
	periphMemWrite(SIM_GPS2_INIT, &pSimBase->sim_gps2);
	#endif

	#ifdef SIM_GPS3_INIT
	periphMemWrite(SIM_GPS3_INIT, &pSimBase->sim_gps3);
	#endif

	#ifdef SIM_PCR_INIT
	periphMemWrite(SIM_PCR_INIT, &pSimBase->sim_pcr);
	#endif

	#ifdef SIM_SD0_INIT
	periphMemWrite(SIM_SD0_INIT, &pSimBase->sim_sd0);
	#endif

	#ifdef SIM_SD1_INIT
	periphMemWrite(SIM_SD1_INIT, &pSimBase->sim_sd1);
	#endif

	#ifdef SIM_SD2_INIT
	periphMemWrite(SIM_SD2_INIT, &pSimBase->sim_sd2);
	#endif

	#ifdef SIM_PCE0_INIT
	periphMemWrite(SIM_PCE0_INIT, &pSimBase->sim_pce0);
	#endif

	#ifdef SIM_PCE1_INIT
	periphMemWrite(SIM_PCE1_INIT, &pSimBase->sim_pce1);
	#endif

	#ifdef SIM_PCE2_INIT
	periphMemWrite(SIM_PCE2_INIT, &pSimBase->sim_pce2);
	#endif

	#ifdef SIM_PROT_INIT
	periphMemWrite(SIM_PROT_INIT, &pSimBase->sim_prot);
	#endif

	/* LVI is initialized here as a part of SYS initialization */	
	#ifdef LVI_CONTROL_INIT
	periphMemWrite(LVI_CONTROL_INIT, &LVI->ps_ctlr);
	#endif
}

#ifdef __cplusplus
}
#endif
