/******************************************************************************
* 
* Copyright (c) 2009 Freescale Semiconductor;
* All Rights Reserved                       
*
******************************************************************************* 
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
***************************************************************************//*!
*
* @file      SPI_TWR-56F8257.c
*
* @author    rg002c
* 
* @version   1.0.1.0
* 
* @date      Aug-26-2009
* 
* @brief     SPI driver to support MC33937 on the board TWR-56F8257

*
*******************************************************************************
*
* SPI driver to support MC33937 on the board TWR-MC-LV3PH controlled by TWR-56F8257.
*
******************************************************************************/

/******************************************************************************
* Includes
******************************************************************************/
#include "types.h"
#include "arch.h"
#include "periph.h"
#include "SPI_TWR56F8257.h"


/*****************************************************************************
* External objects
******************************************************************************/
asm void Cpu_Delay(int ns266);

/******************************************************************************
* Global variables
******************************************************************************/

/******************************************************************************
* Constants and macros
******************************************************************************/

#define SPSCR_SPTE_MASK	 1
#define SPSCR_SPRF_MASK	 8

/******************************************************************************
* Local function prototypes
******************************************************************************/

/******************************************************************************
* Local variables
******************************************************************************/

/******************************************************************************
* Local functions
******************************************************************************/

/******************************************************************************
* Global functions
******************************************************************************/

/***************************************************************************//*!
*
* @brief  SPI initialization function
*
* @remarks 	Initializes the SPI module for communication with 3pp.
*
****************************************************************************/
void SPI_Init(void)
{
	/* Spi data size and control register */
	ArchIO.Spi.spdscr = 0x0007;
	
 	/* Setup Spi control register */
	ArchIO.Spi.spscr = 0x65A0;
	    
}

/***************************************************************************//*!
*
* @brief  Send/Receive data to/from SPI
*
* @param  in    		byte bytData
*                         - 8-bit data to be send
*
* @return This function returns
*     - UWord8 8-bit data
*		
* @remarks 	The function sends data via SPI with a length of 8 bits and
*           at the same instants receives 8 bit data. This routine is used
*           for communication with 3pp.
*
****************************************************************************/
byte SPI_Send(byte bytData)
{

	periphBitClear(0x0080,&ArchIO.PortC.DataReg); /* clear SS - GPIO_C7*/
   
  /* Waits until empty buffer */
	while((ArchIO.Spi.spscr & SPSCR_SPTE_MASK) == 0)/* test SPTE bit */
	{
	};
  ArchIO.Spi.spdtr = bytData;

  /* Waits until data transferred  */
  while((ArchIO.Spi.spscr & SPSCR_SPRF_MASK) == 0) /* test SPRF bit */
  {
  };
	periphBitSet(0x0080,&ArchIO.PortC.DataReg);/* set SS */

  /* Return received data */
  return((unsigned char)ArchIO.Spi.spdrr);      
}
