/*******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2004-2007 Freescale Semiconductor, Inc.
* (c) Copyright 2001-2004 Motorola, Inc.
* ALL RIGHTS RESERVED.
*
********************************************************************************
*
* File Name: appconfig.h
*
* Description: file for static configuration of the application
*              (initial values, interrupt vectors)
*
* Modules Included:
*
*****************************************************************************/

#ifndef __APPCONFIG_H
#define __APPCONFIG_H

/*.*************************************************************************
*
*  File generated by Graphical Configuration Tool Wed, 26/Oct/2011, 16:10:47
*
****************************************************************************.*/

#define MC56F8257
#define EXTCLK 8000000L
#define APPCFG_DFLTS_OMITTED 1
#define APPCFG_GCT_VERSION 0x02050300L

/*.
    OCCS Configuration
--------------------------------------------
    Core frequency: 60 MHz 
    VCO frequency: 240 MHz 
    Loss of lock interrupt 0: Disable 
    Loss of lock interrupt 1: Disable 
    Loss of reference clock Interrupt: Disable
.*/
#define OCCS_CTRL_INIT                    0x0082U
#define OCCS_DIVBY_INIT                   0x201DU
#define OCCS_OSCTL_INIT                   0x3A00U
#define OCCS_USE_FACTORY_TRIM             1

/*.
    COP Configuration
--------------------------------------------
    COP clock source: Relaxation oscilator 
    COP operation: Disable
    COP timeout: 8.38848 sec 
    COP Runs in Stop Mode: No 
    COP Runs in Wait Mode: No 
    COP Write Protect: No 
    Enable Loss of Clock COP: No
.*/
#define COP_COPCTL_INIT                   0x0300U

/*.
    SYS Configuration
--------------------------------------------
    SIM: Power Saving Modes: Stop enabled , Wait enabled 
         OnCE clock to processor core: Enabled when core TAP enabled 
    SIM - Interrupts: Low voltage 2.2V: Disable
                      Low voltage 2.7V: Disable
    SIM - Clock on GPIO: Enable CLKOUT: No , Source: Continuous System Clock 
    SIM - Peripheral Clock Enable: GPIO F: Yes, GPIO E: Yes, GPIO D: No , GPIO C: Yes, GPIO B: Yes, GPIO A: Yes, ADC: Yes
                                   TMR A0: Yes, TMR A1: Yes, TMR A2: Yes, TMR A3: Yes, TMR B0: No 
                                   TMR B1: No , TMR B2: No , TMR B3: No , DAC: No 
                                   HSCMP A: No , HSCMP B: No , HSCMP C: No , SCI0: No , SCI1: Yes, QSPI0: Yes, IIC0: No 
                                   IIC1: No , CRC: No , REFA: No , REFB: No , REFC: No , HFM: No , MSCAN: Yes, PWMCH0: Yes
                                   PWMCH1: Yes, PWMCH2: Yes, PWMCH3: Yes, SIM - Modules Enabled in Stop: GPIO F: No , SIM - Modules Enabled in Stop: GPIO E: No , SIM - Modules Enabled in Stop: GPIO D: No , SIM - Modules Enabled in Stop: GPIO C: No , SIM - Modules Enabled in Stop: GPIO B: No , SIM - Modules Enabled in Stop: GPIO A: No , SIM - Modules Enabled in Stop: ADC: No 
    SIM - Modules Enabled in Stop: TMR A0: No , TMR A1: No , TMR A2: No , TMR A3: No , TMR B0: No 
                                   TMR B1: No , TMR B2: No , TMR B3: No , DAC: No 
                                   CMP A: No , CMP B: No , CMP C: No , SCI0: No , SCI1: No , QSPI0: No , IIC0: No 
                                   IIC1: No , CRC: No , REFA: No , REFB: No , REFC: No , MSCAN: No , PWMCH0: No 
                                   PWMCH1: No , PWMCH2: No , PWMCH3: No , Protection of IPS and GPSxx  : Registers not protected 
    Protection of PCE, SD and PCR: Registers not protected 
    GPIO Peripheral select registers (GPSn): ANA0/CMPA_2P 
                                             XTAL 
                                             XB_IN2 
                                             TA0 
                                             TA1 
                                             DACO 
                                             TA2 
                                             SS 
                                             MISO 
                                             SCLK 
                                             MOSI 
                                             TXD1 
                                             RXD1 
                                             TA3 
                                             SDA0 
                                             SCL0 
                                             PWMB2 
                                             PWMA2 
                                             PWMB3 
                                             PWMA3 
                                             CLKO 
                                             SCL1 
                                             SDA1 
                                             TXD1 
                                             RXD1 
                                             TB2 
                                             RXD0 
    QTIMER B input selection (GPSn): GPIO C2 
                                     GPIO F8 
                                     GPIO F6 
                                     GPIO F7
.*/
#define SIM_GPS0_INIT                     0x0020U
#define SIM_GPS1_INIT                     0x0280U
#define SIM_PCE0_INIT                     0xF0F6U
#define SIM_PCE1_INIT                     0x0301U
#define SIM_PCE2_INIT                     0x000FU

/*.
    INTC Configuration
--------------------------------------------
    All maskable interrupts disabled: No
.*/
#define INTC_ICTL_INIT                    0x0000U
#define INT_VECTOR_ADDR_39                IsrQTA3Compare
#define INT_PRIORITY_LEVEL_39             INTC_LEVEL2
#define INT_VECTOR_ADDR_40                IsrHallSensorC
#define INT_PRIORITY_LEVEL_40             INTC_LEVEL1
#define INT_VECTOR_ADDR_41                IsrHallSensorB
#define INT_PRIORITY_LEVEL_41             INTC_LEVEL1
#define INT_VECTOR_ADDR_42                IsrHallSensorA
#define INT_PRIORITY_LEVEL_42             INTC_LEVEL1

/*.
    QT_A0 Configuration
--------------------------------------------
    Count mode: Counting mode, count rising edges of primary source 
    Timer Channel Enabled (counter starts counting immediatelly after initialized): Yes
    Primary source: Prescaler (IPB clock/ 128) , Secondary: Counter #0 input pin 
    Input polarity: True , Output polarity: True 
    Input capture mode: Load capture register on both edges of secondary input 
    Output mode: Asserted while counter is active 
    Count stop mode: Count repeatedly , Count length: Roll over , Count direction: Count up 
    Output enable (OFLAG to pin): No 
    Force OFLAG output at startup: No , Forced OFLAG value: 0
    Master mode (broadcast compare event): Disable
    Enable external OFLAG force (on broadcasted event): No 
    Co-channel initialization (on broadcasted event): No 
    Preload Control: 1: Never , Load Reg: 0
                     2: Never , Load Reg: 0
    Interrupts: Overflow: Disabled
                Input edge: Enabled 
                Compare: Disabled
                Cmp 1: Disabled
                Cmp 2: Disabled
    Input Filter: Input Signal Sampling [timer clocks] : 2
                  Consecutive Samples Required to Agree: 4 
                  Input Signal Latency: 0.16667 us 
    Fault function: No 
    Alternative Load: No 
    Reload on Capture: No 
    Debug action: Continue
.*/
#define QT_A0_CTRL_INIT                   0x3E00U
#define QT_A0_SCR_INIT                    0x04C0U
#define QT_A0_FILT_INIT                   0x0102U

/*.
    QT_A1 Configuration
--------------------------------------------
    Count mode: Counting mode, count rising edges of primary source 
    Timer Channel Enabled (counter starts counting immediatelly after initialized): Yes
    Primary source: Prescaler (IPB clock/ 128) , Secondary: Counter #1 input pin 
    Input polarity: True , Output polarity: True 
    Input capture mode: Load capture register on both edges of secondary input 
    Output mode: Asserted while counter is active 
    Count stop mode: Count repeatedly , Count length: Roll over , Count direction: Count up 
    Output enable (OFLAG to pin): No 
    Force OFLAG output at startup: No , Forced OFLAG value: 0
    Master mode (broadcast compare event): Disable
    Enable external OFLAG force (on broadcasted event): No 
    Co-channel initialization (on broadcasted event): No 
    Preload Control: 1: Never , Load Reg: 0
                     2: Never , Load Reg: 0
    Interrupts: Overflow: Disabled
                Input edge: Enabled 
                Compare: Disabled
                Cmp 1: Disabled
                Cmp 2: Disabled
    Input Filter: Input Signal Sampling [timer clocks] : 2
                  Consecutive Samples Required to Agree: 4 
                  Input Signal Latency: 0.16667 us 
    Fault function: No 
    Alternative Load: No 
    Reload on Capture: No 
    Debug action: Continue
.*/
#define QT_A1_CTRL_INIT                   0x3E80U
#define QT_A1_SCR_INIT                    0x04C0U
#define QT_A1_FILT_INIT                   0x0102U

/*.
    QT_A2 Configuration
--------------------------------------------
    Count mode: Counting mode, count rising edges of primary source 
    Timer Channel Enabled (counter starts counting immediatelly after initialized): Yes
    Primary source: Prescaler (IPB clock/ 128) , Secondary: Counter #2 input pin 
    Input polarity: True , Output polarity: True 
    Input capture mode: Load capture register on both edges of secondary input 
    Output mode: Asserted while counter is active 
    Count stop mode: Count repeatedly , Count length: Roll over , Count direction: Count up 
    Output enable (OFLAG to pin): No 
    Force OFLAG output at startup: No , Forced OFLAG value: 0
    Master mode (broadcast compare event): Disable
    Enable external OFLAG force (on broadcasted event): No 
    Co-channel initialization (on broadcasted event): No 
    Preload Control: 1: Never , Load Reg: 0
                     2: Never , Load Reg: 0
    Interrupts: Overflow: Disabled
                Input edge: Enabled 
                Compare: Disabled
                Cmp 1: Disabled
                Cmp 2: Disabled
    Input Filter: Input Signal Sampling [timer clocks] : 2
                  Consecutive Samples Required to Agree: 4 
                  Input Signal Latency: 0.16667 us 
    Fault function: No 
    Alternative Load: No 
    Reload on Capture: No 
    Debug action: Continue
.*/
#define QT_A2_CTRL_INIT                   0x3F00U
#define QT_A2_SCR_INIT                    0x04C0U
#define QT_A2_FILT_INIT                   0x0102U

/*.
    QT_A3 Configuration
--------------------------------------------
    Count mode: Counting mode, count rising edges of primary source 
    Timer Channel Enabled (counter starts counting immediatelly after initialized): Yes
    Primary source: Prescaler (IPB clock/ 16) , 
    Input polarity: True , Output polarity: True 
    Input capture mode: Capture disabled, Input Edge Flag disabled 
    Output mode: Asserted while counter is active 
    Count stop mode: Count repeatedly , Count length: Count until compare and reinitialize , Count direction: Count up 
    Output enable (OFLAG to pin): No 
    Force OFLAG output at startup: No , Forced OFLAG value: 0
    Master mode (broadcast compare event): Disable
    Enable external OFLAG force (on broadcasted event): No 
    Co-channel initialization (on broadcasted event): No 
    Preload Control: 1: Never , Load Reg: 0
                     2: Never , Load Reg: 0
    Interrupts: Overflow: Disabled
                Input edge: Disabled
                Compare: Enabled 
                Cmp 1: Disabled
                Cmp 2: Disabled
    Input Filter: Input Signal Sampling [timer clocks] : 0
                  Consecutive Samples Required to Agree: 3 
                  Input Signal Latency: OFF 
    Fault function: No 
    Alternative Load: No 
    Reload on Capture: No 
    Debug action: Continue
.*/
#define QT_A3_CTRL_INIT                   0x3820U
#define QT_A3_SCR_INIT                    0x4000U
#define QT_A3_CMP1_INIT                   0x927CU

/*.
    GPIO_A Configuration
--------------------------------------------
    Pin  0: Function: GPIO , Direction: Input , PullUp: Enable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  1: Function: GPIO , Direction: Input , PullUp: Enable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  2: Function: GPIO , Direction: Input , PullUp: Enable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  3: Function: GPIO , Direction: Input , PullUp: Enable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  4: Function: GPIO , Direction: Input , PullUp: Enable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  5: Function: GPIO , Direction: Input , PullUp: Enable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  6: Function: GPIO , Direction: Input , PullUp: Enable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  7: Function: GPIO , Direction: Input , PullUp: Enable , Interrupt: Disable, Int.Polarity: Active high ,
.*/
#define GPIO_A_PER_INIT                   0x0000U

/*.
    GPIO_B Configuration
--------------------------------------------
    Pin  0: Function: ANB0/CMPB_P2 , PullUp: Enable , 
    Pin  1: Function: GPIO , Direction: Input , PullUp: Enable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  2: Function: GPIO , Direction: Input , PullUp: Enable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  3: Function: GPIO , Direction: Input , PullUp: Enable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  4: Function: GPIO , Direction: Output , Init.Value: Low - 0 , Interrupt: Disable, Int.Polarity: Active high , Output-Mode: Push-pull , 
    Pin  5: Function: GPIO , Direction: Input , PullUp: Enable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  6: Function: GPIO , Direction: Input , PullUp: Enable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  7: Function: GPIO , Direction: Input , PullUp: Enable , Interrupt: Disable, Int.Polarity: Active high ,
.*/
#define GPIO_B_DDR_INIT                   0x0010U
#define GPIO_B_PER_INIT                   0x0001U

/*.
    GPIO_C Configuration
--------------------------------------------
    Pin  0: Function: GPIO , Direction: Input , PullUp: Enable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  1: Function: GPIO , Direction: Input , PullUp: Enable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  2: Function: XB_IN2 , PullUp: Enable , 
    Pin  3: Function: TA0 , PullUp: Enable , 
    Pin  4: Function: TA1 , PullUp: Enable , 
    Pin  5: Function: GPIO , Direction: Input , PullUp: Enable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  6: Function: TA2 , PullUp: Enable , 
    Pin  7: Function: GPIO , Direction: Output , Init.Value: High - 1 , Interrupt: Disable, Int.Polarity: Active high , Output-Mode: Push-pull , 
    Pin  8: Function: MISO , PullUp: Enable , 
    Pin  9: Function: SCLK , PullUp: Enable , 
    Pin 10: Function: MOSI , PullUp: Enable , 
    Pin 11: Function: GPIO , Direction: Input , PullUp: Enable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin 12: Function: GPIO , Direction: Input , PullUp: Enable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin 13: Function: GPIO , Direction: Input , PullUp: Enable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin 14: Function: GPIO , Direction: Input , PullUp: Enable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin 15: Function: GPIO , Direction: Input , PullUp: Enable , Interrupt: Disable, Int.Polarity: Active high ,
.*/
#define GPIO_C_DDR_INIT                   0x0080U
#define GPIO_C_PER_INIT                   0x075CU
#define GPIO_C_DR_INIT                    0x0080U

/*.
    GPIO_E Configuration
--------------------------------------------
    Pin  0: Function: PWM0B , PullUp: Enable , 
    Pin  1: Function: PWM0A , PullUp: Enable , 
    Pin  2: Function: PWM1B , PullUp: Enable , 
    Pin  3: Function: PWM1A , PullUp: Enable , 
    Pin  4: Function: PWM2B , PullUp: Enable , 
    Pin  5: Function: PWM2A , PullUp: Enable , 
    Pin  6: Function: GPIO , Direction: Input , PullUp: Enable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  7: Function: GPIO , Direction: Input , PullUp: Enable , Interrupt: Disable, Int.Polarity: Active high ,
.*/
#define GPIO_E_PER_INIT                   0x003FU

/*.
    GPIO_F Configuration
--------------------------------------------
    Pin  0: Function: GPIO , Direction: Output , Init.Value: Low - 0 , Interrupt: Disable, Int.Polarity: Active high , Output-Mode: Push-pull , 
    Pin  1: Function: GPIO , Direction: Output , Init.Value: Low - 0 , Interrupt: Disable, Int.Polarity: Active high , Output-Mode: Push-pull , 
    Pin  2: Function: GPIO , Direction: Output , Init.Value: Low - 0 , Interrupt: Disable, Int.Polarity: Active high , Output-Mode: Push-pull , 
    Pin  3: Function: GPIO , Direction: Output , Init.Value: Low - 0 , Interrupt: Disable, Int.Polarity: Active high , Output-Mode: Push-pull , 
    Pin  4: Function: TXD1 , PullUp: Enable , 
    Pin  5: Function: RXD1 , PullUp: Enable , 
    Pin  6: Function: GPIO , Direction: Input , PullUp: Enable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  7: Function: GPIO , Direction: Input , PullUp: Enable , Interrupt: Disable, Int.Polarity: Active high , 
    Pin  8: Function: GPIO , Direction: Output , Init.Value: Low - 0 , Interrupt: Disable, Int.Polarity: Active high , Output-Mode: Push-pull ,
.*/
#define GPIO_F_DDR_INIT                   0x010FU
#define GPIO_F_PER_INIT                   0x0030U

/*.
    XBAR Configuration
--------------------------------------------
    Crossbar output 0.: Logic 0 
    Crossbar output 1.: Logic 0 
    Crossbar output 2.: Logic 0 
    Crossbar output 3.: Logic 0 
    Crossbar output 4.: Logic 0 
    Crossbar output 5.: Logic 0 
    Crossbar output 6.: PWM0_TRIG_COMB 
    Crossbar output 7.: Logic 0 
    Crossbar output 8.: Logic 0 
    Crossbar output 9.: Logic 0 
    Crossbar output 10.: Logic 0 
    Crossbar output 11.: Logic 0 
    Crossbar output 12.: Logic 0 
    Crossbar output 13.: Logic 0 
    Crossbar output 14.: Logic 0 
    Crossbar output 15.: Logic 0 
    Crossbar output 16.: Logic 0 
    Crossbar output 17.: Logic 0 
    Crossbar output 18.: Logic 0 
    Crossbar output 19.: Logic 0 
    Crossbar output 20.: Logic 0 
    Crossbar output 21.: GPIO_C 2 / GPIO_E 4 
    Crossbar output 22.: Logic 0 
    Crossbar output 23.: Logic 0 
    Crossbar output 24.: Logic 0 
    Crossbar output 25.: Logic 0 
    Crossbar output 26.: Logic 0 
    Crossbar output 27.: Logic 0 
    Crossbar output 28.: Logic 0 
    Crossbar output 29.: Logic 0
.*/
#define XBAR_XBC3_INIT                    0x0010U
#define XBAR_XBC10_INIT                   0x0200U

/*.
    PWM_Common Configuration
--------------------------------------------
    Monitor PLL State: Not locked. No PLL check 
    Fault0 Level: High 
    Fault1 Level: Low 
    Fault2 Level: Low 
    Fault3 Level: Low 
    Fault0 Clearing: Automatic 
    Fault1 Clearing: Manual 
    Fault2 Clearing: Manual 
    Fault3 Clearing: Manual 
    Fault0 Safety Mode: Normal 
    Fault1 Safety Mode: Normal 
    Fault2 Safety Mode: Normal 
    Fault3 Safety Mode: Normal 
    Fault0 Full Cycle: Full&Half 
    Fault1 Full Cycle: Full&Half 
    Fault2 Full Cycle: Full&Half 
    Fault3 Full Cycle: Full&Half 
    Fault Glitch Stretching: Enabled 
    Fault Filter Period: 0
    Fault Filter Count: 3 
    Fault 0 Pin: Disable
    Fault 1 Pin: Disable
    Fault 2 Pin: Disable
    Fault 3 Pin: Disable
    Submodule 0: Disable Pins PWMA by Fault: Fault 0: Yes
                 Disable Pins PWMA by Fault: Fault 1: No 
                 Disable Pins PWMA by Fault: Fault 2: No 
                 Disable Pins PWMA by Fault: Fault 3: No 
                 Disable Pins PWMB by Fault: Fault 0: Yes
                 Disable Pins PWMB by Fault: Fault 1: No 
                 Disable Pins PWMB by Fault: Fault 2: No 
                 Disable Pins PWMB by Fault: Fault 3: No 
                 Disable Pins PWMX by Fault: Fault 0: No 
                 Disable Pins PWMX by Fault: Fault 1: No 
                 Disable Pins PWMX by Fault: Fault 2: No 
                 Disable Pins PWMX by Fault: Fault 3: No 
                 Disable Pins PWMX by Fault: PWMA Fault State: Logic 1 
                 Disable Pins PWMX by Fault: PWMB Fault State: Logic 0 
                 Disable Pins PWMX by Fault: PWMX Fault State: Logic 0 
    Submodule 1: Disable Pins PWMA by Fault: Fault 0: Yes
                 Disable Pins PWMA by Fault: Fault 1: No 
                 Disable Pins PWMA by Fault: Fault 2: No 
                 Disable Pins PWMA by Fault: Fault 3: No 
                 Disable Pins PWMB by Fault: Fault 0: Yes
                 Disable Pins PWMB by Fault: Fault 1: No 
                 Disable Pins PWMB by Fault: Fault 2: No 
                 Disable Pins PWMB by Fault: Fault 3: No 
                 Disable Pins PWMX by Fault: Fault 0: No 
                 Disable Pins PWMX by Fault: Fault 1: No 
                 Disable Pins PWMX by Fault: Fault 2: No 
                 Disable Pins PWMX by Fault: Fault 3: No 
                 Disable Pins PWMX by Fault: PWMA Fault State: Logic 0 
                 Disable Pins PWMX by Fault: PWMB Fault State: Logic 1 
                 Disable Pins PWMX by Fault: PWMX Fault State: Logic 0 
    Submodule 2: Disable Pins PWMA by Fault: Fault 0: Yes
                 Disable Pins PWMA by Fault: Fault 1: No 
                 Disable Pins PWMA by Fault: Fault 2: No 
                 Disable Pins PWMA by Fault: Fault 3: No 
                 Disable Pins PWMB by Fault: Fault 0: Yes
                 Disable Pins PWMB by Fault: Fault 1: No 
                 Disable Pins PWMB by Fault: Fault 2: No 
                 Disable Pins PWMB by Fault: Fault 3: No 
                 Disable Pins PWMX by Fault: Fault 0: No 
                 Disable Pins PWMX by Fault: Fault 1: No 
                 Disable Pins PWMX by Fault: Fault 2: No 
                 Disable Pins PWMX by Fault: Fault 3: No 
                 Disable Pins PWMX by Fault: PWMA Fault State: Logic 1 
                 Disable Pins PWMX by Fault: PWMB Fault State: Logic 0 
                 Disable Pins PWMX by Fault: PWMX Fault State: Logic 0 
    Submodule 3: Disable Pins PWMA by Fault: Fault 0: Yes
                 Disable Pins PWMA by Fault: Fault 1: Yes
                 Disable Pins PWMA by Fault: Fault 2: Yes
                 Disable Pins PWMA by Fault: Fault 3: Yes
                 Disable Pins PWMB by Fault: Fault 0: Yes
                 Disable Pins PWMB by Fault: Fault 1: Yes
                 Disable Pins PWMB by Fault: Fault 2: Yes
                 Disable Pins PWMB by Fault: Fault 3: Yes
                 Disable Pins PWMX by Fault: Fault 0: Yes
                 Disable Pins PWMX by Fault: Fault 1: Yes
                 Disable Pins PWMX by Fault: Fault 2: Yes
                 Disable Pins PWMX by Fault: Fault 3: Yes
                 Disable Pins PWMX by Fault: PWMA Fault State: Logic 0 
                 Disable Pins PWMX by Fault: PWMB Fault State: Logic 0 
                 Disable Pins PWMX by Fault: PWMX Fault State: Logic 0
.*/
#define PWM_MCTRL_INIT                    0x0707U
#define PWM_MCTRL2_INIT                   0x0000U
#define PWM_FCTRL_INIT                    0x1100U

/*.
    PWM_0 Configuration
--------------------------------------------
    Debug Mode Operation: Stop 
    Wait Mode Operation: Stop 
    Load Mode: End cycle 
    Load OK: Yes
    PWM Clock Enable: Yes
    Clock Source: IPBus Clock 
    Prescaler: fclk/1 
    INIT register: 0
    VAL1 register: 3749
    Fraction (FRACVAL1): 0
    Fraction delay block enable: 1: No 
                                 2 & 3: No 
                                 4 & 5: No 
    Fraction Power: No 
    Sync. source: Local sync (PWMX) 
    Reload source: This module 
    Reload Frequency: Every opportunity 
    Half Cycle Reload: Disable
    Full Cycle Reload: Enable 
    PWMA Mask: Normal 
    PWMB Mask: Normal 
    PWMX Mask: Normal 
    PWMA Output Polarity: Active Low 
    PWMB Output Polarity: Active High 
    PWMX Output Polarity: Active High 
    PWMA Output enable: Disabled 
    PWMB Output enable: Disabled 
    PWMX Output enable: Disabled 
    PWMA and PWMB Pair Operation: Complementary 
    Initialize value registers: Enable 
    PWM Value 2: 0
    PWM Value 3: 0
    PWM Fractional Value 2: 0
    PWM Fractional Value 3: 0
    PWM Value 4: 0
    PWM Value 5: 0
    PWM Fractional Value 4: 0
    PWM Fractional Value 5: 0
    PWM Value X: 0
    Enable double switch: No 
    Value 0: Disable
    Value1: Disable
    Value 2: Disable
    Value3: Disable
    Value 4: Enable 
    Value5: Disable
    Double Switching: PWM23 
    Deadtime count 1: 60
    Software Controlled Output: Logic 0 
                                Logic 0 
    Force Initialization Enable: Yes
    Source of FORCE OUTPUT signal: Local force CTRL2[FORCE] 
    Dead Time Source 23: PWM23 
    Dead Time Source 45: PWM45 
    PWM45 Initial Value: Logic 0 
                         Logic 0 
    PWMX Initial Value: Logic 0 
    Reload: Disable
    Reload Error: Disable
    Value 0 Compare: Disable
    Value 1 Compare: Disable
    Value 2 Compare: Disable
    Value 3 Compare: Disable
    Value 4 Compare: Disable
    Value 5 Compare: Disable
.*/
#define PWM_0_CTRL_INIT                   0x0400U
#define PWM_0_CTRL2_INIT                  0x0080U
#define PWM_0_USE_PWMVAL                  1
#define PWM_0_INIT_INIT                   0x0000U
#define PWM_0_VAL1_INIT                   0x0EA5U
#define PWM_0_VAL0_INIT                   0x0000U
#define PWM_0_VAL2_INIT                   0x0000U
#define PWM_0_VAL3_INIT                   0x0000U
#define PWM_0_VAL4_INIT                   0x0000U
#define PWM_0_VAL5_INIT                   0x0000U
#define PWM_0_FRACVAL2_INIT               0x0000U
#define PWM_0_FRACVAL3_INIT               0x0000U
#define PWM_0_FRACVAL4_INIT               0x0000U
#define PWM_0_FRACVAL5_INIT               0x0000U
#define PWM_0_OCTRL_INIT                  0x0410U
#define PWM_0_TCTRL_INIT                  0x0010U
#define PWM_0_DTCNT0_INIT                 0xF83CU
#define PWM_0_DTCNT1_INIT                 0xF83CU
#define PWM_0_DISMAP_INIT                 0xF011U

/*.
    PWM_1 Configuration
--------------------------------------------
    Debug Mode Operation: Stop 
    Wait Mode Operation: Stop 
    Load Mode: End cycle 
    Load OK: Yes
    PWM Clock Enable: Yes
    Clock Source: PWM_0 clock 
    Prescaler: fclk/1 
    INIT register: 0
    VAL1 register: 3749
    Fraction (FRACVAL1): 0
    Fraction delay block enable: 1: No 
                                 2 & 3: No 
                                 4 & 5: No 
    Fraction Power: No 
    Sync. source: Master sync (PWM_0) 
    Reload source: PWM_0 module 
    Reload Frequency: Every opportunity 
    Half Cycle Reload: Disable
    Full Cycle Reload: Enable 
    PWMA Mask: Normal 
    PWMB Mask: Normal 
    PWMX Mask: Normal 
    PWMA Output Polarity: Active Low 
    PWMB Output Polarity: Active High 
    PWMX Output Polarity: Active High 
    PWMA Output enable: Disabled 
    PWMB Output enable: Disabled 
    PWMX Output enable: Disabled 
    PWMA and PWMB Pair Operation: Complementary 
    Initialize value registers: Enable 
    PWM Value 2: 0
    PWM Value 3: 0
    PWM Fractional Value 2: 0
    PWM Fractional Value 3: 0
    PWM Value 4: 0
    PWM Value 5: 0
    PWM Fractional Value 4: 0
    PWM Fractional Value 5: 0
    PWM Value X: 0
    Enable double switch: No 
    Value 0: Disable
    Value1: Disable
    Value 2: Disable
    Value3: Disable
    Value 4: Disable
    Value5: Disable
    Double Switching: PWM23 
    Deadtime count 1: 60
    Software Controlled Output: Logic 0 
                                Logic 0 
    Force Initialization Enable: Yes
    Source of FORCE OUTPUT signal: Master force (PWM_0) 
    Dead Time Source 23: PWM23 
    Dead Time Source 45: PWM45 
    PWM45 Initial Value: Logic 0 
                         Logic 0 
    PWMX Initial Value: Logic 0 
    Reload: Disable
    Reload Error: Disable
    Value 0 Compare: Disable
    Value 1 Compare: Disable
    Value 2 Compare: Disable
    Value 3 Compare: Disable
    Value 4 Compare: Disable
    Value 5 Compare: Disable
.*/
#define PWM_1_CTRL_INIT                   0x0400U
#define PWM_1_CTRL2_INIT                  0x028EU
#define PWM_1_USE_PWMVAL                  1
#define PWM_1_INIT_INIT                   0x0000U
#define PWM_1_VAL1_INIT                   0x0EA5U
#define PWM_1_VAL0_INIT                   0x0000U
#define PWM_1_VAL2_INIT                   0x0000U
#define PWM_1_VAL3_INIT                   0x0000U
#define PWM_1_VAL4_INIT                   0x0000U
#define PWM_1_VAL5_INIT                   0x0000U
#define PWM_1_FRACVAL2_INIT               0x0000U
#define PWM_1_FRACVAL3_INIT               0x0000U
#define PWM_1_FRACVAL4_INIT               0x0000U
#define PWM_1_FRACVAL5_INIT               0x0000U
#define PWM_1_OCTRL_INIT                  0x0404U
#define PWM_1_DTCNT0_INIT                 0xF83CU
#define PWM_1_DTCNT1_INIT                 0xF83CU
#define PWM_1_DISMAP_INIT                 0xF011U

/*.
    PWM_2 Configuration
--------------------------------------------
    Debug Mode Operation: Stop 
    Wait Mode Operation: Stop 
    Load Mode: End cycle 
    Load OK: Yes
    PWM Clock Enable: Yes
    Clock Source: PWM_0 clock 
    Prescaler: fclk/1 
    INIT register: 0
    VAL1 register: 3749
    Fraction (FRACVAL1): 0
    Fraction delay block enable: 1: No 
                                 2 & 3: No 
                                 4 & 5: No 
    Fraction Power: No 
    Sync. source: Master sync (PWM_0) 
    Reload source: PWM_0 module 
    Reload Frequency: Every opportunity 
    Half Cycle Reload: Disable
    Full Cycle Reload: Enable 
    PWMA Mask: Normal 
    PWMB Mask: Normal 
    PWMX Mask: Normal 
    PWMA Output Polarity: Active Low 
    PWMB Output Polarity: Active High 
    PWMX Output Polarity: Active High 
    PWMA Output enable: Disabled 
    PWMB Output enable: Disabled 
    PWMX Output enable: Disabled 
    PWMA and PWMB Pair Operation: Complementary 
    Initialize value registers: Enable 
    PWM Value 2: 0
    PWM Value 3: 0
    PWM Fractional Value 2: 0
    PWM Fractional Value 3: 0
    PWM Value 4: 0
    PWM Value 5: 0
    PWM Fractional Value 4: 0
    PWM Fractional Value 5: 0
    PWM Value X: 0
    Enable double switch: No 
    Value 0: Disable
    Value1: Disable
    Value 2: Disable
    Value3: Disable
    Value 4: Disable
    Value5: Disable
    Double Switching: PWM23 
    Deadtime count 1: 60
    Software Controlled Output: Logic 0 
                                Logic 0 
    Force Initialization Enable: Yes
    Source of FORCE OUTPUT signal: Master force (PWM_0) 
    Dead Time Source 23: PWM23 
    Dead Time Source 45: PWM45 
    PWM45 Initial Value: Logic 0 
                         Logic 0 
    PWMX Initial Value: Logic 0 
    Reload: Disable
    Reload Error: Disable
    Value 0 Compare: Disable
    Value 1 Compare: Disable
    Value 2 Compare: Disable
    Value 3 Compare: Disable
    Value 4 Compare: Disable
    Value 5 Compare: Disable
.*/
#define PWM_2_CTRL_INIT                   0x0400U
#define PWM_2_CTRL2_INIT                  0x028EU
#define PWM_2_USE_PWMVAL                  1
#define PWM_2_INIT_INIT                   0x0000U
#define PWM_2_VAL1_INIT                   0x0EA5U
#define PWM_2_VAL0_INIT                   0x0000U
#define PWM_2_VAL2_INIT                   0x0000U
#define PWM_2_VAL3_INIT                   0x0000U
#define PWM_2_VAL4_INIT                   0x0000U
#define PWM_2_VAL5_INIT                   0x0000U
#define PWM_2_FRACVAL2_INIT               0x0000U
#define PWM_2_FRACVAL3_INIT               0x0000U
#define PWM_2_FRACVAL4_INIT               0x0000U
#define PWM_2_FRACVAL5_INIT               0x0000U
#define PWM_2_OCTRL_INIT                  0x0410U
#define PWM_2_DTCNT0_INIT                 0xF83CU
#define PWM_2_DTCNT1_INIT                 0xF83CU
#define PWM_2_DISMAP_INIT                 0xF011U

/*.
    ADC Configuration
--------------------------------------------
    Clock frequency: 6 MHz 
    Trigger source: SYNC0 input 
    Channel Configuration: ANA0-ANA1: Single ended , ANA2-ANA3: Single ended 
                           ANB0-ANB1: Single ended , ANB2-ANB3: Single ended 
                           ANA4-ANA5: Single ended , ANA6-ANA7: Single ended 
                           ANB4-ANB5: Single ended , ANB6-ANB7: Single ended 
    Channel to Sample Mapping: SMP0: ANB0 , 
    Scan Mode: Triggered sequential 
    Enabled samples: SMP0 
    Zero crossing mode: SMP0: Disabled , SMP1: Disabled , SMP2: Disabled , SMP3: Disabled 
                        SMP4: Disabled , SMP5: Disabled , SMP6: Disabled , SMP7: Disabled 
    Auto Power Down Mode: Disable
    Auto Stand-by Mode: Disable
    Power down converter A (ANA0-ANA7): No 
    Power down converter B (ANB0-ANB7): No 
    Power down voltage reference: No 
    Power up delay: 1, Power Control: 0.16667 us 
    Converter1 VREFLO source: Internal VSSA
    Converter1 VREFH  source: Internal VDDA
    Converter0 VREFLO source: Internal VSSA
    Converter0 VREFH  source: Internal VDDA
    Interrupts: ANA Conversion complete: Disabled
                High limit error: Disabled
                Low limit error: Disabled
                Zero crossing: Disabled
    ANA channel Gain Configuguration: Gain ANA0: 1x , Gain ANA1: 1x 
                                      Gain ANA2: 1x , Gain ANA3: 1x 
                                      Gain ANA4: 1x , Gain ANA5: 1x 
                                      Gain ANA6: 1x , Gain ANA7: 1x 
    ANB channel Gain Configuguration: Gain ANB0: 1x , Gain ANB1: 1x 
                                      Gain ANB2: 1x , Gain ANB3: 1x 
                                      Gain ANB4: 1x , Gain ANB5: 1x 
                                      Gain ANB6: 1x , Gain ANB7: 1x 
    Power Mode: Power mode ANA: up to 15MHz 
                Power mode ANB: up to 15MHz
.*/
#define ADC_ADCR1_INIT                    0x1004U
#define ADC_ADCR2_INIT                    0x0024U
#define ADC_ADLST1_INIT                   0x3244U
#define ADC_ADLST2_INIT                   0x7654U
#define ADC_ADLST3_INIT                   0xBA98U
#define ADC_ADLST4_INIT                   0xFEDCU
#define ADC_ADSDIS_INIT                   0xFF6EU
#define ADC_ADCPOWER_INIT                 0x0010U
#define ADC_ADCPWR2_INIT                  0x020AU

/*.
    SCI_1 Configuration
--------------------------------------------
    Baudrate: 9600 bps 
    Enable Receiver: Enable 
    Enable Transmitter: Enable 
    Data word length: 8 bits 
    Parity: None 
    Polarity: True polarity 
    Loop mode: Disable
    Function in Wait Mode: SCI module enabled in Wait Mode 
    Interrupts: RX Full: Disable
                RX Error: Disable
                TX Empty: Disable
                TX Empty: Disable
    Enable RX and TX FIFO Queues: Disable
.*/
#define SCI_1_SCIBR_INIT                  0x0C35U
#define SCI_1_SCICR_INIT                  0x000CU
#define SCI_1_SCICR2_INIT                 0x0000U
#define SCI_1_RX_BUFFER_OKLIMIT           0x000FU
#define SCI_1_RX_BUFFER_LOWLIMIT          0x000AU

/*.
    SPI Configuration
--------------------------------------------
    SPI Module Enable: Enable 
    Clock frequency: 468.75 kHz 
    SPI Mode: Master 
    SCLK Polarity: Falling edge 
    SCLK Phase: Transmission started by edge on SS pin 
    Shift order: MSB first 
    Wired OR mode: Normal 
    SS Mode Fault Enable: Enable 
    Interrupts: Receiver: Disable
                Error: Disable
                Transmitter: Disable
    Enable RX and TX FIFO Queues: Disable
.*/
#define SPI_SPDSCR_INIT                   0x0007U
#define SPI_SPSCR_INIT                    0xC5A0U

/*.
    FMSTR Configuration
--------------------------------------------
.*/
#define FMSTR_COMM_INTERFACE              2
#define FMSTR_LONG_INTR                   0
#define FMSTR_SHORT_INTR                  0
#define FMSTR_POLL_DRIVEN                 1


/*.         End of autogenerated code
********************************************************************** ..*/

#endif
