/*
 * File:		uart_isr.c
 * Purpose:		interrupt handler routines for the Kinetis uart tests
 *
 */

#include "common.h"

/********************************************************************/  
/* Generic UART LON interrupt handler.
 * This function will check all possible interrupt sources, so if 
 * there are multiple error conditions they will all be handled.
 */
void 
uart0_lon_isr(void)
{
    //printf("\n****UART0 LON Interrupt Handler*****\n");
     
    /* Check to see if the Wbase expired flag is set */
    if (UART0_S3 & UART_S3_WBEF_MASK)
    {
        printf("\nUART LON Wbase expired flag detected.\n");

        /* Write 1 to flag to clear the flag */
        UART0_S3 = UART_S3_WBEF_MASK;
    }
    
    /* Check to see if the Initial sync detect flag is set */
    if (UART0_S3 & UART_S3_ISD_MASK)
    {
        //printf("\nUART LON initial sync detected.\n");

        /* The ISD flag cannot be cleared, so disable the interrupt
         * in order to avoid getting continuous interrupts from this
         * point on.
         */
        UART0_IE &= ~UART_IE_ISDIE_MASK;
    }
    
    /* Check to see if the packet received flag is set */
    if (UART0_S3 & UART_S3_PRXF_MASK)
    {        
        //printf("\nUART LON packet received flag detected.\n");

        /* Write 1 to flag to clear the flag */
        UART0_S3 = UART_S3_PRXF_MASK;
    }

    /* Check to see if the packet transmitted flag is set */
    if (UART0_S3 & UART_S3_PTXF_MASK)
    {
        /* Disable transmit to prevent a second packet from attempting to go out */
        UART0_C6 &= ~UART_C6_TX709_MASK;
    
        //printf("\nUART LON packet transmitted flag detected.\n");

        /* Write 1 to flag to clear the flag */
        UART0_S3 = UART_S3_PTXF_MASK;
    }
  
    /* Check to see if the packet cycle timer expired flag is set */
    if (UART0_S3 & UART_S3_PCTEF_MASK)
    { 
        //printf("\nUART LON packet cycle timer expired flag detected.\n");

        /* Write 1 to flag to clear the flag */
        UART0_S3 = UART_S3_PCTEF_MASK;
    }
  
    /* Check to see if the preamble start flag is set */
    if (UART0_S3 & UART_S3_PSF_MASK)
    {
        //printf("\nUART LON preamble transmit flag detected.\n");

        /* Write 1 to flag to clear the flag */
        UART0_S3 = UART_S3_PSF_MASK;
    }
    
    /* Check to see if the transmit fail flag is set */
    if (UART0_S3 & UART_S3_TXFF_MASK)
    {
        //printf("\nUART LON transmit failed flag detected.\n");

        /* Write 1 to flag to clear the flag */
        UART0_S3 = UART_S3_TXFF_MASK;
    }
    
}

/******************************************************************************/   
