/**
  \mainpage 
  \n Copyright (c) 2011 Freescale
  \n Freescale Confidential Proprietary 
  \brief 
  \author   	Freescale Semiconductor
  \author    
  \version      m.n
  \date         Sep 14, 2011

*/
/****************************************************************************************************/
/*                                                                                                  */
/* All software, source code, included documentation, and any implied know-how are property of      */
/* Freescale Semiconductor and therefore considered CONFIDENTIAL INFORMATION.                       */
/* This confidential information is disclosed FOR DEMONSTRATION PURPOSES ONLY.                      */
/*                                                                                                  */
/* All Confidential Information remains the property of Freescale Semiconductor and will not be     */
/* copied or reproduced without the express written permission of the Discloser, except for copies  */
/* that are absolutely necessary in order to fulfill the Purpose.                                   */
/*                                                                                                  */
/* Services performed by FREESCALE in this matter are performed AS IS and without any warranty.     */
/* CUSTOMER retains the final decision relative to the total design and functionality of the end    */
/* product.                                                                                         */
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the success of this project.*/
/*                                                                                                  */
/* FREESCALE disclaims all warranties, express, implied or statutory including, but not limited to, */
/* implied warranty of merchantability or fitness for a particular purpose on any hardware,         */
/* software ore advise supplied to the project by FREESCALE, and or any product resulting from      */
/* FREESCALE services.                                                                              */
/* In no event shall FREESCALE be liable for incidental or consequential damages arising out of     */
/* this agreement. CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or */
/* actions by anyone on account of any damage,or injury, whether commercial, contractual, or        */
/* tortuous, rising directly or indirectly as a result of the advise or assistance supplied CUSTOMER*/ 
/* in connectionwith product, services or goods supplied under this Agreement.                      */
/*                                                                                                  */
/****************************************************************************************************/

/*****************************************************************************************************
* Include files
*****************************************************************************************************/
#include "common.h"
#include "uart.h"

/**
 * \brief   main
 * \author  
 * \param  none
 * \return none
 * \todo
 * \warning
 */

extern int core_clk_khz;
uint8 u8Array[] = {'C','E','A','7','0','9','.','1'};

/*prototypes*/
extern int 
uart_lon_basic_tx(UART_MemMapPtr module, uint8 ch);
extern int 
uart_lon_tx_array(UART_MemMapPtr module, uint8 *data, uint8 tx_len);
extern int 
uart_lon_basic_rx(UART_MemMapPtr module, uint8 *ch);
extern int 
uart_lon_rx_array(UART_MemMapPtr module, uint8 *data, uint8 rx_len);

/*main function*/
int 
main (void)
{
	uint8 ch;

#ifdef KEIL
	start();
#endif
        
        /*UART0 LON implementation*/
        if(TERM_PORT==UART0_BASE_PTR)
        {
          printf("Printf is already using UART0 port\n\r");
        }
        else
        {
          /*FSL: configure LON pins: Rx and Tx, not using COL pin*/
          
          /* Enable the UART0_RXD function on PTD6 */
          PORTD_PCR6 = PORT_PCR_MUX(0x3) ; // UART is alt3 function for this pin
          /* Enable the UART0_TXD function on PTD7 */
          PORTD_PCR7 = PORT_PCR_MUX(0x3) ; // UART is alt3 function for this pin
          
          /* LON is only present in UART0: select UART0 pads at sysinit.c */
          uart_init (UART0_BASE_PTR, core_clk_khz,TERMINAL_BAUD/*78000*/);
        
  	  printf("\nRunning the lon_example project in K2050MHz family\n");
          
          /*send a single character through CEA709.1*/
          (void)uart_lon_basic_tx(UART0_BASE_PTR, 0x55);
          
          /*receive a single character through CEA709.1*/
          (void)uart_lon_basic_rx(UART0_BASE_PTR, &ch);
          
          /*send multiple characters through CEA709.1*/
          (void)uart_lon_tx_array(UART0_BASE_PTR, &u8Array[0], sizeof(u8Array));
          
          /*receive multiple characters through CEA709.1*/
          (void)uart_lon_rx_array(UART0_BASE_PTR, &u8Array[0], sizeof(u8Array));
        }

	for(;;)
	{
	  ch = getchar();
	  putchar(ch);
	} 
}
/********************************************************************/
