//***********************************************************************
// FILE: standalone_romrun.ld                                           *
//                                                                      *
// DESCRIPTION:                                                         *
// Linker definition file for MPC5676R project                          *
//======================================================================*
// UPDATE HISTORY                                                       *
// Revision    Author      Date          Description of change          *
// 1.0         D. Erazmus  12/13/2010    Initial version.               *
//======================================================================*
// COPYRIGHT (c) Freescale Semiconductor, Inc. 2011                     *
// All Rights Reserved                                                  *
//***********************************************************************

DEFAULTS {
    SRAM_SIZE       = 384K
    SRAM_MMU_SIZE   = 512K
    SRAM_BASE_ADDR  = 0x40000000     
    STACK_SIZE_0    = 4K                        // 4KB Stack for core 0
    STACK_SIZE_1    = 4k                        // 4KB Stack for core 1

    stack_reserve = 4k
    heap_reserve  = 4k
}

MEMORY {

//  6M Internal Flash
    flash_rsvd1  : ORIGIN = 0x00000000, LENGTH = 8
    flash_memory : ORIGIN = .,          LENGTH = 6M-8
    flash_rsvd2  : ORIGIN = .,          LENGTH = 0 


// 384KB of internal SRAM starting at 0x40000000
    dram_rsvd1   : ORIGIN = 0x40000000, LENGTH = 0x200
    dram_reset   : ORIGIN = .,          LENGTH = 0
    dram_memory  : ORIGIN = .,          LENGTH = SRAM_SIZE-0x200
    dram_rsvd2   : ORIGIN = .,          LENGTH = 0

// 4k of stack per core to be locked in cache
    stack_ram0   : ORIGIN = SRAM_BASE_ADDR+SRAM_MMU_SIZE,              LENGTH = STACK_SIZE_0
    stack_ram1   : ORIGIN = SRAM_BASE_ADDR+SRAM_MMU_SIZE+STACK_SIZE_0, LENGTH = STACK_SIZE_1
}

//
// Program layout for starting in ROM, copying data to RAM,
// and continuing to execute out of ROM.
//

SECTIONS
{

//
// RAM SECTIONS
//
    .PPC.EMB.sdata0                                 ABS : > dram_memory
    .PPC.EMB.sbss0                            CLEAR ABS : > .
   
    .sdabase                                  ALIGN(16) : > dram_memory    
    .sdata                                              : > .
    .sbss                                               : > .
    .data                                               : > .
    .bss                                                : > .
    .heap                   ALIGN(16) PAD(heap_reserve) : > .   
    .__exception_handlers                     ALIGN(4k) : > .

    .stack ALIGN(16) PAD(STACK_SIZE_0)  : {} > stack_ram0        // Stack Area  
    .stack1 ALIGN(16) PAD(STACK_SIZE_1) : {} > stack_ram1        // Stack Area  

//
// ROM SECTIONS
//

    .rcw                            NOCHECKSUM   : > flash_rsvd1
    .init                                        : { *(.init) } > flash_memory
    .text                                        : > .
    .vletext                                     : > .
    .syscall                                     : > .

    .rodata                                      : > .
    .sdata2                                      : > .

    .secinfo                                     : > .
    .fixaddr                                     : > .
    .fixtype                                     : > .

    .CROM.PPC.EMB.sdata0   CROM(.PPC.EMB.sdata0) : > .
    .CROM.sdata                     CROM(.sdata) : > .
    .CROM.data                       CROM(.data) : > .

    /* Stack Address Parameters */
    __SP_INIT       = ADDR(.stack) + SIZEOF(stack_ram0);
    __SP_INIT_0     = ADDR(.stack) + SIZEOF(stack_ram0);
    __SP_INIT_1     = ADDR(.stack1) + SIZEOF(stack_ram1);

    __SP_END        = ADDR(.stack);
    __SP_END_0      = ADDR(.stack);
    __SP_END_1      = ADDR(.stack1);
    
    __STACK_SIZE    = SIZEOF(stack_ram0);
    __STACK_SIZE_0  = SIZEOF(stack_ram0);
    __STACK_SIZE_1  = SIZEOF(stack_ram1);

    _SRAM_BASE_ADDR = ADDR(dram_rsvd1);
    _SRAM_SIZE      = SIZEOF(dram_rsvd1) + SIZEOF(dram_reset) + SIZEOF(dram_memory) + SIZEOF(dram_rsvd2);

//
// These special symbols mark the bounds of RAM and ROM memory.
// They are used by the MULTI debugger.
//
    __ghs_ramstart  = MEMADDR(dram_rsvd1);
    __ghs_ramend    = MEMENDADDR(dram_memory);
    __ghs_romstart  = MEMADDR(flash_rsvd1);
    __ghs_romend    = MEMENDADDR(flash_rsvd2);

//
// These special symbols mark the bounds of RAM and ROM images of boot code.
// They are used by the GHS startup code (_start and __ghs_ind_crt0).
//
    __ghs_rambootcodestart  = 0;
    __ghs_rambootcodeend    = 0;
    __ghs_rombootcodestart  = ADDR(.text);
    __ghs_rombootcodeend    = ENDADDR(.fixtype);
}

