/************************************************************************/
/* FILE: main.c                                                         */
/*                                                                      */
/* DESCRIPTION:                                                         */
/* Example project for MPC5676R.                                        */
/*======================================================================*/
/* UPDATE HISTORY                                                       */
/* Revision    Author      Date          Description of change          */
/* 1.0         D. Erazmus  12/13/2010    Initial version.               */
/*======================================================================*/
/* COPYRIGHT (c) Freescale Semiconductor, Inc. 2011                     */
/* All Rights Reserved                                                  */
/************************************************************************/

/**************************************************
INCLUDE FILES
**************************************************/         
#include <ppc_ghs.h>

#include "MPC567xR.h"
#include "siu.h"

#define RSTVEC_VLE         1
#define RSTVEC_RESET     0x2
#define RSTVEC_RST_MASK 0xFFFFFFFC

/**************************************************
Global vars
**************************************************/
extern unsigned long __start;

/**************************************************/
/*                      MAIN                      */
/**************************************************/
int main (void)
{
    int pid;
    
    asm ("e_li    r0, 0x4000");    
    asm ("mthid0  r0");                /* enable TB and decrementer */

    pid = __MFSPR(286);

    if (pid == 0)
    {
        volatile int i;
        
        SIU.PCR[144].R = ALT0 | OBE;    //PA=0, OBE=1 for GPIO[0] PA[1]

        /* Start Core 1 in VLE mode */
        SIU.RSTVEC1.R = ((unsigned long)&__start & RSTVEC_RST_MASK) | RSTVEC_VLE;
        
        while (1)    /* loop forever (core 0) */
        {
            i++;
            if (i % 1000000 == 0)
            {
                SIU.GPDO[144].R  ^= 1;
            }
        }
    } else {
        volatile int i;

        SIU.PCR[113].R = ALT0 | OBE;    //PA=0, OBE=1 for GPIO[0] PA[0] 

        while (1)    /* loop forever (core 1) */
        {
            i++;
            if (i % 1000000 == 0)
            {
                SIU.GPDO[113].R  ^= 1;
            }
        }
    }

}   /* end of main */                          

