#include "pwm_ctrl.h"
#include "pwm_cfg.h"
#include "adc_cfg.h"
#include "acmp_cfg.h"

#define PWM_SLEW_DELAY      (unsigned int)5000
#define ON_DIAG_DELAY_INIT  (unsigned long)0x000FFFFF


static Bool FS_Diagnostic         = FALSE;
static Bool PWM_Reached           = FALSE;
static unsigned char PWM_Duty_Cmd = 255;
static unsigned char PWM_Slew     = 0;
static int  Slew_Delay            = PWM_SLEW_DELAY;
static unsigned long Load_OnDelay  = ON_DIAG_DELAY_INIT;

/******************************************************************************
Function Name  : Duty_Out_Slew
Engineer       : b30269	
Date           : 03/05/2011
Parameters     : New PWM val 
Returns        : NONE
Notes          : This function will update PWM value using slew rate until 
                 PWM_Duty_Cmd equals PWMDTY0, increase/decrease resolution is 
                 1/255,
                 
*****************************************************************************/

void Duty_Out_Slew(void)
{
   if(!PWM_Off) 
   {
      if(PWM_CH1_DUTY != PWM_Duty_Cmd)
      {
         PWM_Reached = FALSE;

         if(0 == Slew_Delay)
         {
            if(PWM_Duty_Cmd < PWM_CH1_DUTY)
            {
               PWM_Slew --;
            }
            else if(PWM_Duty_Cmd > PWM_CH1_DUTY) 
            {
               PWM_Slew ++;
            }
            else
            {
               ; /* Duty commanded has been reached */
            }   

            PWM_CH1_DUTY = PWM_Slew;
            Slew_Delay = PWM_SLEW_DELAY;
         }
         else
         {
            Slew_Delay --;
         }
      }
      else
      {
         PWM_Reached = TRUE;
      } 
      
   }
   else
   {
      PWM_Slew      = PWM_OUT_MIN;
      PWM_CH1_DUTY  = PWM_OUT_MIN;
   }

}

/******************************************************************************
Function Name  : Set_LoadOnDelay
Engineer       : b30269	
Date           : 03/05/2011
Parameters     : None 
Returns        : NONE
Notes          : This function initializes a delay to determine if the failure
                 flags can be cleared, it is used after a failure has been
                 detected.
                 
*****************************************************************************/
void Set_LoadOnDelay(void)
{
   Load_OnDelay  = ON_DIAG_DELAY_INIT;
}

/******************************************************************************
Function Name  : LoadOnDiagDelay
Engineer       : b30269	
Date           : 03/05/2011
Parameters     : None 
Returns        : NONE
Notes          : This function decrements a delay if not equal to zero, 
                 this delay is used to determine if fault flags are going 
                 to be cleared or not, after the load has been activated.
                 
*****************************************************************************/
void LoadOnDiagDelay(void)
{
   if(0 < Load_OnDelay ) 
   {
      Load_OnDelay --;
   }
}

/******************************************************************************
Function Name  : PWM_ClearOutDiag
Engineer       : b30269	
Date           : 03/05/2011
Parameters     : None 
Returns        : NONE
Notes          : This function clears the system load diagnostics.
                 
*****************************************************************************/
void PWM_ClearOutDiag(void)
{
   if(0 == Load_OnDelay)
   {
      FS_Diagnostic   = FALSE;
      CSNS_Diagnostic = FALSE;  
   }
}

#pragma CODE_SEG NON_BANKED
#pragma TRAP_PROC
__interrupt VectorNumber_Vportj void Failure_State(void) 
{ 
   PJ0_ClearInterrupt_Flag();
   
   Set_LoadOnDelay();
   
   FS_Diagnostic = TRUE;
   PWM_Off        = TRUE;
}
#pragma CODE_SEG DEFAULT
