#include <hidef.h>           /* common defines and macros */
#include "derivative.h"      /* derivative-specific definitions */


#define PWM_CH0       1
#define PWM_CH1       2
#define PWM_CH2       4
#define PWM_CH3       8
#define PWM_CH4      16
#define PWM_CH5      32
#define PWM_CH6      64
#define PWM_CH7     128

#define PWM_4KHz_SA_SCL_4MHz    0x0C
#define PWM_1KHz_SA_SCL_8MHz    0x3C

#define PWM_CENTER_ALIGN        0
#define PWM_LEFT_ALIGN          1

#define PWM_ENABLE              1
#define PWM_DISABLE             0
#define PWM_LPM_DISABLE         0

#define PWM_Scale_SA_Clk(sa_clk)     PWMSCLA = (sa_clk)
#define PWM_Set_Init_Duty(duty)      PWMDTY1 = (duty)
#define PWM_Align_Mode(mode)         PWMCAE  = (mode)
#define PWM_LPM_Mode(lpm_mode)       PWMCTL  = (lpm_mode)                       

#define PWM_CH1_DUTY                 PWMDTY1
#define PJ0_ClearInterrupt_Flag()   PIFJ_PIFJ0 = 1                                     

#define PWM_IO_LOW    0
#define PWM_IO_HI     1

#define PWM_OUT_MIN 255

/*============================================================================*\
     Exported objects
\*============================================================================*/
extern Bool  PWM_Off;

/*============================================================================*\
     Exported functions 
\*============================================================================*/
extern void  PWM_Cfg(void);
extern void  PWM_Ch_Enable(char channel);
extern void  PWM_Ch_Shut_Dwn(unsigned char ch);
extern void  PWM_ClearOutDiag(void);
