/******************************************************************************
  FILE        : main.c
  PURPOSE     : Call application routines.
  MACHINE     : Freescale 68HC12 (Target)
  LANGUAGE    : ANSI-C
  HISTORY     : Dec 2010   b30269 First version created
******************************************************************************/
#include <hidef.h>           /* common defines and macros */
#include "derivative.h"      /* derivative-specific definitions */

#include "pwm_cfg.h"
#include "pwm_ctrl.h"
#include "adc_cfg.h"
#include "acmp_cfg.h"


/******************************************************************************/

#define Enable_RTI_Interrupt() CPMURTI |=  (CPMURTI_RTDEC_MASK | CPMURTI_RTR0_MASK); /* set RTI for 250 us */\
                               CPMUINT |=   CPMUINT_RTIE_MASK                        /* enable RTI         */


/* Bits peripheral register access macros */
#define testReg8Bits(RegName, GetMask)                           (RegName & (GetMask))

#define clrReg8Bits(RegName, ClrMask)                            (RegName &= ~(uint8_t)(ClrMask))

#define setReg8Bits(RegName, SetMask)                            (RegName |= (uint8_t)(SetMask))

#define invertReg8Bits(RegName, InvMask)                         (RegName ^= (uint8_t)(InvMask))

#define clrSetReg8Bits(RegName, ClrMask, SetMask)                (RegName = (RegName & (~(uint8_t)(ClrMask))) | (uint8_t)(SetMask))

#define seqClrSetReg8Bits(RegName, BitsMask, BitsVal)            (RegName &= ~(~(uint8_t)(BitsVal) & (uint8_t)(BitsMask)),\
                                                                  RegName |= (uint8_t)(BitsVal) & (uint8_t)(BitsMask) )
#define seqSetClrReg8Bits(RegName, BitsMask, BitsVal)            (RegName |= (uint8_t)(BitsVal) & (uint8_t)(BitsMask),\
                                                                  RegName &= ~(~(uint8_t)(BitsVal) & (uint8_t)(BitsMask)) )
#define seqResetSetReg8Bits(RegName, BitsMask, BitsVal)          (RegName &= ~(uint8_t)(BitsMask),\
                                                                  RegName |= (uint8_t)(BitsVal) & (uint8_t)(BitsMask) )
#define clrReg8BitsByOne(RegName, ClrMask, BitsMask)             (RegName &= (uint8_t)(ClrMask) & (uint8_t)(BitsMask))



/******************************************************************************
Function Name  : Configure_CRG
Engineer       : b30269	
Date           : 14/12/10
Parameters     : NONE
Returns        : NONE
Notes          : CRG configuration to run at 32MHz bus clk: 
                                  
******************************************************************************/
void Configure_CPMU(void)
{
   /* 
      Initialise the system clock for Normal mode: 
      - 64MHz VCO, 32MHz PLL, 32MHz Bus CLK, from 8MHz Crystal 
   */
	
   CPMUSYNR    = 0x58;     /* SYNDIV = , VCO frequency  MHz         */

   CPMUREFDIV  = 0x07;     /* REFDIV =  REFCLK frequency  MHz         */     

   CPMUPOSTDIV = 0x00;     /* POSTDIV =                                    */

   while(!CPMUFLG_LOCK)
   {
      ;                /* 
                          Wait for VCO to stabilize, if failure occurs 
                          WD will be triggered
                       */
   }			 
 
   CPMUCLKS_PLLSEL = 1;  /* Switch clk to use PLL */
}


void FailureStateInterrruptInit(void)
{  
  
  
  DDRJ_DDRJ0      = 0;  /* PORTAD0 as input          */
  PERJ            = 1;  /* activate pull up          */
  
  PPSJ_PPSJ0      = 0;  /* Falling edge interrupt    */
  
  PIEJ_PIEJ0      = 1;  /* Enable Port AD0 interrupt */

}

void Init_On_Delay(void)
{
   if(0 < On_Delay ) 
   {
      On_Delay--;
   }
}


void main(void) 
{

   Configure_CPMU();
   
   _FEED_COP();
   
   /* Enable RTI to be used as filter sampling period */
   
   Enable_RTI_Interrupt();

   /**********************************/
   
   PWM_Cfg();
  
   /**********************************/
	 
   ADC_An1Init();
   
   /**********************************/
   
   ACMP_Init();
   
   /**********************************/
	 
   FailureStateInterrruptInit();

   /**********************************/
  
   EnableInterrupts;
   /**********************************/
  
   for(;;) 
   {
      /* Feeds the dog */
      _FEED_COP(); 
      
      /* Update the new PWM duty value */
      Duty_Out_Slew();
      /* Run Diagnostic recovery delay after load activation */
      if(!PWM_Off)
      {
         LoadOnDiagDelay();
      }
      /* Evaluate if diagnostic indication is cleared */
      PWM_ClearOutDiag();   
      /* Diagnose Load State */
      
      if(!PWM_Off)
      {
         Init_On_Delay();
      }
      
      if(0 == On_Delay)
      {
         OpenLoadMonitor();
      }
      
   } /* loop forever */
   /* please make sure that you never leave main */
}
