#include <hidef.h>           /* common defines and macros */
#include "derivative.h"      /* derivative-specific definitions */

typedef unsigned char   uint8_t;              /* Must be exactly 8-bit unsigned  */
typedef unsigned short  uint16_t;             /* Must be exactly 16-bit unsigned */
typedef unsigned long   uint32_t;             /* Must be exactly 32-bit unsigned */
typedef unsigned long   uint64_t;             /* Must be exactly 64-bit unsigned */

typedef signed   char   int8_t;              /* Must be exactly  8-bit signed */
typedef signed   short  int16_t;             /* Must be exactly 16-bit signed */
typedef signed   long   int32_t;             /* Must be exactly 32-bit signed */
typedef signed   long   int64_t;             /* Must be exactly 64-bit unsigned */

typedef unsigned char   bit_field8_t;         /* Used for byte wide bit fields   */
typedef unsigned short  bit_field16_t;        /* Used for word length bit fields */
typedef unsigned long   bit_field32_t;        /* Used for long length bit fields */
typedef unsigned long   bit_field64_t;        /* Used for long length bit fields */

/* Bit-field types */

typedef unsigned char   bitfield8_t;
typedef unsigned short  bitfield16_t;
typedef unsigned long   bitfield32_t;
typedef unsigned long   bitfield64_t;

typedef unsigned char   bool;
typedef unsigned char   boolean_t;            /* Forces boolean to be 1 byte */




/**************************************************
* 8-bit byte wide structure that allows either    *
* full byte access or either of the 4 bit nibbles *
* of a byte.                                      *
**************************************************/
#define MSB_FIRST        0       /* The most significant bit is the first bit of the bit field */
#define LSB_FIRST        1       /* The least significant bit is the first bit of the bit field */
#define HIGH_BYTE_FIRST  0       /* Within a uint16, the high byte is located before the low byte */
#define LOW_BYTE_FIRST   1       /* Within a uint16, the low byte is located befor the high byte */
#define HIGH_WORD_FIRST  0       /* Within a uint32, the high word (16 bit) is located before the low word */
#define LOW_WORD_FIRST   1       /* Within a uint32, the low word (16 bit) is located before the high word */

            
#define CPU_BIT_ORDER       LSB_FIRST
#define CPU_BYTE_ORDER      HIGH_BYTE_FIRST
#define CPU_WORD_ORDER      HIGH_WORD_FIRST

/*****************************************************
* 16-bit word wide port structure that allows either *
* full word 16-bit word access, or alternately       *
* upper byte/lower byte access.                      *
* The high/low byte order is BigEndian for Motorola. *
*****************************************************/

typedef union
{
    uint16_t     Word;
#if CPU_BYTE_ORDER == LOW_BYTE_FIRST
    struct  {
       uint8_t   LoByte;
       uint8_t   HiByte;    
    } Field;
#else  /*  MS Byte First - incerse order */
    struct  {
       uint8_t   HiByte;
       uint8_t   LoByte;    
    } Field;
#endif
} U_Word16_T;

