/******************************************************************************
  FILE        : ACMP_Cfg.c
  PURPOSE     : ACMP (Analog comparator) configuration file.
  MACHINE     : Freescale 68HC12G32 (Target)
  LANGUAGE    : ANSI-C
  HISTORY     : Feb 2011   b30269 First version created
******************************************************************************/

#include <hidef.h>           /* common defines and macros */
#include "derivative.h"      /* derivative-specific definitions */

#include "acmp_cfg.h"
#include "pwm_cfg.h"
#include "pwm_ctrl.h"

Bool CSNS_Diagnostic = FALSE;

void ACMP_Init(void)
{
   
   /* ACMP Interrupt Enable */
   ACMPC |= ACMPC_ACIE_MASK;
   /* ACMOD = 2, interupt detected on falling edges */
   ACMPC |= ACMPC_ACMOD1_MASK;
   
   /* Make sure comparator interrupt flag is cleared */ 
   ACMPS |= ACMPS_ACIF_MASK;
   /* Enable comparator */
   ACMPC |= ACMPC_ACE_MASK;         
}

#pragma CODE_SEG NON_BANKED
#pragma TRAP_PROC
__interrupt VectorNumber_Vacmp void ACMP_Protection(void) 
{ 
   /* Clear ACMP interrupt flag */ 
   ACMPS |= ACMPS_ACIF_MASK;
   /* Stop the system, disable load */
   Set_LoadOnDelay();
   PWM_Off = TRUE;
   CSNS_Diagnostic = TRUE;
}
#pragma CODE_SEG DEFAULT

