
/*
 *  LICENSE:
 *  Copyright (c) 2010 Freescale Semiconductor
 *  
 *  Permission is hereby granted, free of charge, to any person 
 *  obtaining a copy of this software and associated documentation 
 *  files (the "Software"), to deal in the Software without 
 *  restriction, including without limitation the rights to use, 
 *  copy, modify, merge, publish, distribute, sublicense, and/or 
 *  sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following 
 *  conditions:
 *  
 *  The above copyright notice and this permission notice 
 *  shall be included in all copies or substantial portions 
 *  of the Software.
 *  
 *  THIS SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
 *  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES 
 *  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 *  NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT 
 *  HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
 *  WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 *  
 * Composed By: Sim, Mong Tee                                                 
 * Dated      : February 12, 2010                                                
 * Compiler   : Green Hill Multi                                              
 *                                                                            
 * Feature    : This is a SRAM Image project to run via the BAM download mechanism.
 *               
 *
 *              For more details, please refer to my application note
 *              
 *                                                                          
 */

#include "stm.h"

#ifdef __cplusplus
extern "C" {
#endif

//---------------------------------------------------------------------------
// STM_init
//---------------------------------------------------------------------------
void STM_init(uint32_t STM_CR)
{
    STM_CR = 0x00000001 | (STM_CR << 8); 
    STM.CR.R = STM_CR;        
}


//---------------------------------------------------------------------------
// STM_read
//---------------------------------------------------------------------------
uint32_t STM_read(void)
{
    return STM.CNT.R;   //read current counter value
}


//---------------------------------------------------------------------------
// STM_elaspe - Non-block function
//---------------------------------------------------------------------------
uint32_t STM_elaspe(uint32_t BeginTime)
{
    uint32_t CurrTime  = 0;
    uint32_t DiffTime  = 0;

    CurrTime = STM.CNT.R;

    if (BeginTime > CurrTime)
    {
        DiffTime = (0xFFFFFFFF - BeginTime) + CurrTime; // If overflow
    }
    else
    {
        DiffTime = CurrTime - BeginTime;                // within range
    }

    return DiffTime;

}


//---------------------------------------------------------------------------
// STM_delay - Blocking function
//---------------------------------------------------------------------------
void STM_delay(uint32_t delay)
{
    uint32_t BeginTime = STM.CNT.R;
    uint32_t CurrTime  = 0;
    uint32_t DiffTime  = 0;

    while(1)
    {
        CurrTime = STM.CNT.R;
        if (BeginTime > CurrTime)
        {
            DiffTime = (0xFFFFFFFF - BeginTime) + CurrTime;
        }
        else
        {
            DiffTime = CurrTime - BeginTime;
        }

        if (DiffTime >= delay) break;
    }
}

#ifdef __cplusplus
}
#endif
