 /* main.h based on gpio_example.h below */
 /*************************************************************************
 * FILE NAME: $RCSfile: gpio_example.h,v $   COPYRIGHT (c) FREESCALE 2004 *
 * DESCRIPTION:                                     All Rights Reserved   *
 * This file contains prototypes and definitions for the sample MPC5500   *
 * program using the the eTPU GPIO function.                              *
 *========================================================================*
 * ORIGINAL AUTHOR: Jeff Loeliger (r12110)                                *
 * $Log: gpio_example.h,v $
 * Revision 1.1  2004/12/08 11:45:09  r47354
 * Updates as per QOM API rel_2_1
 * 
 *........................................................................*
 * 0.1   J. Loeliger  05/Sep/03    Initial version.                       *
 * 0.2   K Terry      29/Apr/04    mod'd for GPIO function test           *
 * 0.3                             Updated for new build structure.       *
 * 0.4   G. Emerson   2/Nov/04     Added etpu_config_t definition         *
 **************************************************************************/
 /* Rev 15/Mar/06 S. Mihalik : modified for eTPU PWM example  */
 /* Rev 16/Jul/07 S. Mihalik : modified for 50 MHz sysclk, 1 MHz TCR1 */
 /* Rev 10/Aug/07 S. Mihalik: modified for 64 MHz sysclk, still 1 MHz TCR1 */

#include "etpu_util.h"

struct etpu_config_t my_etpu_config = {
	FS_ETPU_MISC_DISABLE,	/*MCR register*/

	FS_ETPU_MISC,			/*MISC value from eTPU compiler link file*/

	/*Configure eTPU engine A*/
	FS_ETPU_FILTER_CLOCK_DIV8 +
	FS_ETPU_CHAN_FILTER_3SAMPLE +
	FS_ETPU_ENTRY_TABLE,

	/*Configure eTPU engine A timebases*/
	FS_ETPU_TCR2CTL_DIV8 +
	( 7 << 16) +     /*TCR2 prescaler of 8 (7+1)*/
	FS_ETPU_TCR1CTL_DIV2 +
	31,               /*TCR1 prescaler of 32 (31+1) applied to sysclk/2*/              
	0,

	/*Configure eTPU engine B*/
	FS_ETPU_FILTER_CLOCK_DIV4 +
    FS_ETPU_CHAN_FILTER_3SAMPLE +
	FS_ETPU_ENTRY_TABLE,

	/*Configure eTPU engine B timebases*/
	FS_ETPU_TCR2CTL_DIV8 +
	( 7 << 16) +     /*TCR2 prescaler of 8 (7+1)*/
	FS_ETPU_TCR1CTL_DIV2 +
	3,              /*TCR1 prescaler of 4 (3+1)*/
	0
	};
