/******************************************************************************
* 
* Copyright (c) 2011 Freescale Semiconductor;
* All Rights Reserved                       
*
*******************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
***************************************************************************//*!
*
* @file      screen_number.c
*
* @author    b01119
* 
* @version   0.0.2.0
* 
* @date      Jan-18-2011
* 
* @brief     Screen for testing number object
*
******************************************************************************/

#include "d4cd.h"

// declare the static functions headers
static void Num_OnChange(D4CD_OBJECT* pThis);

// D4CD_NUMBER declaration
D4CD_DECLARE_STD_NUMBER_AUTOSIZE(scrTestNum_NumTest, "Num:", NULL, 0, 0, Num_OnChange)
  
// D4CD_SCREEN declaration
D4CD_DECLARE_SCREEN_BEGIN(scr_testNum, TestNumScreen_, 0 ,0, D4CD_SCREEN_CHAR_CNT, D4CD_SCREEN_LINE_CNT, "Number test", D4CD_USER_CHAR_TABLE_DEFAULT, (D4CD_SCR_F_BCKG))
  D4CD_DECLARE_SCREEN_OBJECT(scrTestNum_NumTest)  
D4CD_DECLARE_SCREEN_END()

// Number On Change call back function
static void Num_OnChange(D4CD_OBJECT* pThis)
{
  D4CD_UNUSED(pThis);
}

// One time called screen function in screen initialization proces
static void TestNumScreen_OnInit()
{
  const D4CD_NUMBER_LIMITS tmp_limits = {1, 500, -500, 1};
  
  // Initialization of number object
  D4CD_NumberSetLimits(&scrTestNum_NumTest, (D4CD_NUMBER_LIMITS*)&tmp_limits);
}

// Screen on Activate function called with each screen activation
static void TestNumScreen_OnActivate()
{

}


// Screen "Main" function called periodically in each D4CD_poll runs
static void TestNumScreen_OnMain()
{
    
}


// Screen on DeActivate function called with each screen deactivation
static void TestNumScreen_OnDeactivate()
{
    
}

// Screen on message function called with each internal massage for this screen
static Byte TestNumScreen_OnObjectMsg(D4CD_MESSAGE* pMsg)
{
    D4CD_UNUSED(pMsg);
    return 0;
}