/******************************************************************************
* 
* Copyright (c) 2011 Freescale Semiconductor;
* All Rights Reserved                       
*
*******************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
***************************************************************************//*!
*
* @file      screen_chckb.c
*
* @author    b01119
* 
* @version   0.0.3.0
* 
* @date      Jan-18-2011
* 
* @brief     Screen for testing check box objects
*
******************************************************************************/

#include "d4cd.h"

// declare the static functions headers
static void ChckB_OnChange(D4CD_OBJECT* pThis);

// D4CD_CHECKBOX declarations
D4CD_DECLARE_STD_CHECKBOX_AUTOSIZE(scrTestChckB_CheckBTest, "First", 0, 0, ChckB_OnChange)
D4CD_DECLARE_STD_CHECKBOX_AUTOSIZE(scrTestChckB_CheckBTest1, "Seco", 8, 0, ChckB_OnChange)
D4CD_DECLARE_STD_CHECKBOX_AUTOSIZE(scrTestChckB_CheckBTest2, "Third", 0, 1, ChckB_OnChange)
D4CD_DECLARE_STD_CHECKBOX_AUTOSIZE(scrTestChckB_CheckBTest3, "Four", 8, 1, ChckB_OnChange)

  
// D4CD_SCREEN declaration
D4CD_DECLARE_SCREEN_BEGIN(scr_testChckB, TestCheckBScreen_, 0 ,0, D4CD_SCREEN_CHAR_CNT, D4CD_SCREEN_LINE_CNT, NULL, D4CD_USER_CHAR_TABLE_DEFAULT, (D4CD_SCR_F_BCKG))
  D4CD_DECLARE_SCREEN_OBJECT(scrTestChckB_CheckBTest)
  D4CD_DECLARE_SCREEN_OBJECT(scrTestChckB_CheckBTest1)
  D4CD_DECLARE_SCREEN_OBJECT(scrTestChckB_CheckBTest2)
  D4CD_DECLARE_SCREEN_OBJECT(scrTestChckB_CheckBTest3)
D4CD_DECLARE_SCREEN_END()

// Check Box On Change call back function
void ChckB_OnChange(D4CD_OBJECT* pThis)
{
  D4CD_UNUSED(pThis);
}

// One time called screen function in screen initialization proces
static void TestCheckBScreen_OnInit()
{

}

// Screen on Activate function called with each screen activation
static void TestCheckBScreen_OnActivate()
{

}


// Screen "Main" function called periodically in each D4CD_poll runs
static void TestCheckBScreen_OnMain()
{
    
}


// Screen on DeActivate function called with each screen deactivation
static void TestCheckBScreen_OnDeactivate()
{
    
}

// Screen on message function called with each internal massage for this screen
static Byte TestCheckBScreen_OnObjectMsg(D4CD_MESSAGE* pMsg)
{
    D4CD_UNUSED(pMsg);
    return 0;
}