  /******************************************************************************
* 
* Copyright (c) 2010 Freescale Semiconductor;
* All Rights Reserved                       
*
*******************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
***************************************************************************//*!
*
* @file      d4cdlcdhw_gpio_8bit_cfg.h
*
* @author    b01119
* 
* @version   0.0.1.0
* 
* @date      Jan-14-2011
* 
* @brief     D4CD driver - gpio_8bit hardware lcd driver configuration header file 
*
*******************************************************************************/

#ifndef __D4CDLCDHW_GPIO_8BIT_CFG_H
#define __D4CDLCDHW_GPIO_8BIT_CFG_H


  /******************************************************************************
  * includes
  ******************************************************************************/
  // include here what the driver need for run for example "derivative.h"
   #include "derivative.h"    /* include peripheral declarations and more for S08 and CV1 */ 
  
  /******************************************************************************
  * Constants
  ******************************************************************************/
  
  //#define D4CDLCD_DISPLAY_MCU_USER_INIT;
  
  /*******************************************
  * Signals definition
  *******************************************/
  #define D4CDLCD_EN              5         // EN   
  #define D4CDLCD_EN_PORT         PTFD      // EN 
  #define D4CDLCD_EN_DDR          PTFDD     // EN    

  #define D4CDLCD_RS              7         // RS 
  #define D4CDLCD_RS_PORT         PTFD      // RS 
  #define D4CDLCD_RS_DDR          PTFDD     // RS 
    
  #define D4CDLCD_RW              6         // RW 
  #define D4CDLCD_RW_PORT         PTFD      // RW 
  #define D4CDLCD_RW_DDR          PTFDD     // RW 
  
  #define D4CDLCD_BACKLIGHT       4         // BACKLIGHT 
  #define D4CDLCD_BACKLIGHT_PORT  PTFD      // BACKLIGHT 
  #define D4CDLCD_BACKLIGHT_DDR   PTFDD     // BACKLIGHT 
  
  
  // I/O port CONFIG for parallel transfer

  #define D4CDLCD_DATA            PTBD      // 8bit bus
  #define D4CDLCD_DATA_DDR        PTBDD     // 8bit bus DDR 
  #define D4CDLCD_DATA_PE         PTBPE     // 8bit bus PE 

  /*********** Power macros - for modification uncoment and modify ***********/
  
  //#define D4CDLCD_INIT_EN OUTPUT(D4CDLCD_EN);
  //#define D4CDLCD_ASSERT_EN RESET(D4CDLCD_EN);
  //#define D4CDLCD_DEASSERT_EN SET(D4CDLCD_EN);
  
  //#define D4CDLCD_INIT_RS OUTPUT(D4CDLCD_RS);
  //#define D4CDLCD_ASSERT_RS RESET(D4CDLCD_RS);
  //#define D4CDLCD_DEASSERT_RS SET(D4CDLCD_RS);
  
  //#define D4CDLCD_INIT_RW OUTPUT(D4CDLCD_RW);
  //#define D4CDLCD_ASSERT_RW RESET(D4CDLCD_RW);
  //#define D4CDLCD_DEASSERT_RW SET(D4CDLCD_RW);
  
  //#define D4CDLCD_INIT_BACKLIGHT OUTPUT(D4CDLCD_BACKLIGHT);
  //#define D4CDLCD_ASSERT_BACKLIGHT RESET(D4CDLCD_BACKLIGHT);
  //#define D4CDLCD_DEASSERT_BACKLIGHT SET(D4CDLCD_BACKLIGHT);
  
  //#define D4CDLCD_INIT_DATA OUTPUT_ALL(D4CDLCD_DATA);
  //#define D4CDLCD_DATA_WRITE(x) D4CDLCD_DATA = x;
  //#define D4CDLCD_DATA_READ(x) x = D4CDLCD_DATA;
  //#define D4CDLCD_DATA_SET2READ INPUT_ALL(D4CDLCD_DATA);
  //#define D4CDLCD_DATA_SET2WRITE OUTPUT_ALL(D4CDLCD_DATA);

#endif /* __D4CDLCDHW_GPIO_8BIT_CFG_H */
