/******************************************************************************
* 
* Copyright (c) 2010 Freescale Semiconductor;
* All Rights Reserved                       
*
*******************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
***************************************************************************//*!
*
* @file      d4cd_math.h
*
* @author    r50233
* 
* @version   0.0.1.0
* 
* @date      Jan-6-2011
* 
* @brief     D4CD Driver math helper functions header file
*
*******************************************************************************/

#ifndef __D4CD_MATH_H
#define __D4CD_MATH_H

/******************************************************************************
* Constants
******************************************************************************/



/******************************************************************************
* Types
******************************************************************************/



/******************************************************************************
* Macros 
******************************************************************************/

// convert deg angle of -180..180 to internal representation (-128..127)
#define D4CD_ANGLE_DEG(deg) (((deg)==180)?0xff:((deg)*0x100/180))

/******************************************************************************
* Global variables
******************************************************************************/


/******************************************************************************
* Global functions
******************************************************************************/

sByte D4CD_Sin(Byte x);
sByte D4CD_Cos(Byte x);

Byte D4CD_MulDivUU8(Byte u1, Byte u2, Byte d);
sByte D4CD_MulDivSU8(sByte s, Byte u, Byte d);

Word D4CD_MulDivUU16(Word u1, Word u2, Word d);
sWord D4CD_MulDivSU16(sWord s, Word u, Word d);

Word D4CD_Abs16(sWord num);

Byte D4CD_Abs8(sByte num);

#ifdef D4CD_COOR_TYPE
  
  #define D4CD_MulDivUU  D4CD_MulDivUU16
  #define D4CD_MulDivSU  D4CD_MulDivSU16
#else
  #define D4CD_MulDivUU  D4CD_MulDivUU8
  #define D4CD_MulDivSU  D4CD_MulDivSU8
#endif

#endif /* __D4CD_MATH_H */