/******************************************************************************
* 
* Copyright (c) 2010 Freescale Semiconductor;
* All Rights Reserved                       
*
*******************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
***************************************************************************//*!
*
* @file      d4cd_font.c
*
* @author    b01119
* 
* @version   0.0.1.0
* 
* @date      Jan-6-2011
* 
* @brief     D4CD driver font c file 
*
******************************************************************************/

#include "d4cd.h"
#include "d4cd_lldapi.h"
#include "d4cd_private.h"


/**************************************************************//*!
*
* Print the String in ASCII in simple format up to 8 columns
*
******************************************************************/
void D4CD_LCD_PrintStr(D4CD_COOR x, D4CD_COOR y, D4CD_CHAR* pText)
{
  Byte i = 0;
  
  (void)D4CD_LLD_LCD.D4CDLCD_GoTo(x, y);
  
  while(pText[i] != 0) {
    
    (void)D4CD_LLD_LCD.D4CDLCD_Send_Char(pText[i]);
    i++;
  }				
}


/**************************************************************//*!
*
* Load user char table
*
******************************************************************/

void D4CD_LoadUserCharTable(D4CD_CHAR_DATA** pCharTable) 
{
  Byte i;
  
  if(pCharTable == NULL)
    return;
  
  i = 0;
  
  while((i < 8) && (*pCharTable != NULL))
  {
    D4CD_LCD_LoadUserChar(pCharTable[i], i);  
    i++;
  }
  
  
}


