#include "derivative.h"
#include <string.h>

#include "irtc.h"


/******************************************************************************
 * Public functions definitions                                               *
 ******************************************************************************/
void IRTC_Init (word ier_mask)
{
  IRTC_UNLOCK();
  IRTC_FILTER01_CTRL = 0x8A;
  IRTC_FILTER23_CTRL = 0x8A;
  IRTC_TAMPER_SCR_L =  0x04;
  IRTC_CTRL_L_ALARM_MATCH    = 3;
  IRTC_CTRL_H_RTC_CLKOUT = 3;   
  IRTC_IER       = ier_mask;                        
  IRTC_LOCK(); 
}


void IRTC_SetIerMask (word ier_mask) 
{ 
  IRTC_UNLOCK (); 
  IRTC_IER = ier_mask; 
  IRTC_LOCK   (); 
}

void IRTC_SetClock (IRTC * ptr)
{  
  IRTC_UNLOCK ();
  while (IRTC_STATUS_L_INVAL);
  IRTC_YEARMON_H          = (char)((short int)ptr->year - BASE_YEAR);
  IRTC_YEARMON_L_MONTH    = (char)ptr->mon;
  IRTC_DAYS_L_DAYS        = (char)ptr->day;
  IRTC_DAYS_H_DAY_OF_WEEK = (char)ptr->wday;
  IRTC_HOURMIN_H_HOURS    = (char)ptr->hour;
  IRTC_HOURMIN_L_MINUTES  = (char)ptr->min;
  IRTC_SECONDS_L_SECONDS  = (char)ptr->sec;
  IRTC_LOCK   ();
}

void IRTC_GetClock (IRTC * ptr)
{
  while (IRTC_STATUS_L_INVAL);  
  ptr->year = (word)(BASE_YEAR + (char)IRTC_YEARMON_H);
  ptr->mon  = (char)IRTC_YEARMON_L_MONTH;
  ptr->day  = (char)IRTC_DAYS_L_DAYS;
  ptr->wday = (char)IRTC_DAYS_H_DAY_OF_WEEK;
  ptr->hour = (char)IRTC_HOURMIN_H_HOURS;
  ptr->min  = (char)IRTC_HOURMIN_L_MINUTES;
  ptr->sec  = (char)IRTC_SECONDS_L_SECONDS;
}

void IRTC_SetAlarmEvent (IRTC * ptr)
{ 
  IRTC_UNLOCK ();
  while (IRTC_STATUS_L_INVAL);
  IRTC_ALM_YRMON_H   = (char)((short int)ptr->year-BASE_YEAR);
  IRTC_ALM_YRMON_L  = (char)ptr->mon;
  IRTC_ALM_DAYS_L_ALM_DAYS    = (char)ptr->day;  
  IRTC_ALM_HM_H_ALM_HOURS     = (char)ptr->hour;
  IRTC_ALM_HM_L_ALM_MINUTES   = (char)ptr->min;
  IRTC_ALM_SEC_L_ALM_SECONDS  = (char)ptr->sec;
  IRTC_LOCK   ();
}

void IRTC_GetTamperEvent (IRTC * ptr)
{ 
  while (IRTC_STATUS_L_INVAL);  
  ptr->year = (word)(BASE_YEAR + (char)IRTC_TTSR_MY_H);
  ptr->mon  = (char)IRTC_TTSR_MY_L_TIME_STAMP_MONTHS;
  ptr->day  = (char)IRTC_TTSR_DAY_L_TIME_STAMP_DAY;
  ptr->wday = (char)-1;
  ptr->hour = (char)IRTC_TTSR_HM_H_TIME_STAMP_HOURS;
  ptr->min  = (char)IRTC_TTSR_HM_L_TIME_STAMP_MINUTES;
  ptr->sec  = (char)IRTC_TTSR_SEC_L_TIME_STAMP_SECONDS;
}

void IRTC_SetCompensation(byte interval, byte compensation)
{
   IRTC_UNLOCK ();
   IRTC_COMPEN_H = interval;
   IRTC_COMPEN_L = compensation;
   IRTC_LOCK ();
}


char IRTC_GetTamperStatus (void) 
{ 
  return (char)IRTC_TAMPER_SCR_H; 
}

void IRTC_SetDownCntVal (word value) 
{ 
  IRTC_UNLOCK (); 
  IRTC_COUNT_DN = value; 
  IRTC_LOCK ();
}

word IRTC_GetDownCntVal (void) 
{ 
  return (word)IRTC_COUNT_DN; 
}


short IRTC_WrToStandByRam (byte addr, byte *ptr, byte len)
{
  if (addr+len <= sizeof(StandbyRAM))
  {
    IRTC_UNLOCK ();
    (void)memcpy ((void *)&StandbyRAM[addr], ptr, len);
    IRTC_LOCK   ();
    return 1;
  }
  return -1;
}

short IRTC_RdFromStandByRam (byte addr, byte *ptr, byte len)
{
  if (addr+len <= sizeof(StandbyRAM))
  {
    (void)memcpy (ptr, (void *)&StandbyRAM[addr], len);
    return 1;
  }
  return -1;
} 



/******************************************************************************
 * interrupt functions definitions                                            *
 ******************************************************************************/
void interrupt VectorNumber_Virtc irtc_isr (void)
{
  word temp_16 = IRTC_ISR & IRTC_IER;
  
 
  /* call interrupt service callback routine */

   
  /* acknowledge interrupt */
  IRTC_UNLOCK (); 
  IRTC_ISR = temp_16; 
  IRTC_IER &= (~IRTC_2HZ_MASK);
  IRTC_LOCK ();
}