/****************************************************************************
 *
 *            Copyright (c) 2006-2007 by CMX Systems, Inc.
 *
 * This software is copyrighted by and is the sole property of
 * CMX.  All rights, title, ownership, or other interests
 * in the software remain the property of CMX.  This
 * software may only be used in accordance with the corresponding
 * license agreement.  Any unauthorized use, duplication, transmission,
 * distribution, or disclosure of this software is expressly forbidden.
 *
 * This Copyright notice may not be removed or modified without prior
 * written consent of CMX.
 *
 * CMX reserves the right to modify this software without notice.
 *
 * CMX Systems, Inc.
 * 12276 San Jose Blvd. #511
 * Jacksonville, FL 32223
 * USA
 *
 * Tel:  (904) 880-1840
 * Fax:  (904) 880-1632
 * http: www.cmx.com
 * email: cmx@cmx.com
 *
 ***************************************************************************/
#include "usb-drv/usb.h"
#include "target.h"
#include "hid_mouse.h"
#include "hid_kbd.h"
#include "hid_generic.h"
/****************************************************************************
 ************************** Macro definitions *******************************
 ***************************************************************************/
/* none */

/****************************************************************************
 ************************** Function predefinitions. ************************
 ***************************************************************************/
/* none */

/****************************************************************************
 ************************** Global variables ********************************
 ***************************************************************************/
/* none */

/****************************************************************************
 ************************** Module variables ********************************
 ***************************************************************************/
/* none */

/****************************************************************************
 ************************** Function definitions ****************************
 ***************************************************************************/

extern void _Startup(void);
extern interrupt void USB_ISR(void);

void (* volatile const _UserEntry[])()@0xEFC0={
  0x9DCC,             // asm NOP(9D), asm JMP(CC)
  _Startup
};

/*Dummy ISR */
interrupt void Dummy_ISR(void) 
{
}


#define BOOTLOADER_START_ADDR 0xF800

 // redirect vector 0xXXC0-0xFFFD to 0xFBC0-0xFBFD
//void (* volatile const _Usr_Vector[])()@0xF7C4= {
void (* volatile const _Usr_Vector[])()@(BOOTLOADER_START_ADDR-0x100+0xC4)={
    Dummy_ISR,        // Int.no.29 RTC                (at XXC4)
    Dummy_ISR,        // Int.no.28 IIC                (at XXC6)
    Dummy_ISR,        // Int.no.27 ACMP               (at XXC8)
    Dummy_ISR,        // Int.no.26 ADC                (at XXCA)
    Dummy_ISR,        // Int.no.25 KBI                (at XXCC)
    Dummy_ISR,        // Int.no.24 SCI2 Transmit      (at XXCE)
    Dummy_ISR,        // Int.no.23 SCI2 Receive       (at XXD0)
    Dummy_ISR,        // Int.no.22 SCI2 Error         (at XXD2)
    Dummy_ISR,        // Int.no.21 SCI1 Transmit      (at XXD4)
    Dummy_ISR,        // Int.no.20 SCI1 Receive       (at XXD6)
    Dummy_ISR,        // Int.no.19 SCI1 error         (at XXD8)
    Dummy_ISR,        // Int.no.18 TPM2 Overflow      (at XXDA)
    Dummy_ISR,        // Int.no.17 TPM2 CH1           (at XXDC)
    Dummy_ISR,        // Int.no.16 TPM2 CH0           (at XXDE)
    Dummy_ISR,        // Int.no.15 TPM1 Overflow      (at XXE0)
    Dummy_ISR,        // Int.no.14 TPM1 CH5           (at XXE2)
    Dummy_ISR,        // Int.no.13 TPM1 CH4           (at XXE4)
    Dummy_ISR,        // Int.no.12 TPM1 CH3           (at XXE6)
    Dummy_ISR,        // Int.no.11 TPM1 CH2           (at XXE8)
    Dummy_ISR,        // Int.no.10 TPM1 CH1           (at XXEA)
    Dummy_ISR,        // Int.no.9  TPM1 CH0           (at XXEC)
    Dummy_ISR,        // Int.no.8  Reserved           (at XXEE)
    USB_ISR,        // Int.no.7  USB Statue         (at XXF0)
    Dummy_ISR,        // Int.no.6  SPI2               (at XXF2)
    Dummy_ISR,        // Int.no.5  SPI1               (at XXF4)
    Dummy_ISR,        // Int.no.4  Loss of lock       (at XXF6)
    Dummy_ISR,        // Int.no.3  LVI                (at XXF8)
    Dummy_ISR,        // Int.no.2  IRQ                (at XXFA)
    USB_ISR,        // Int.no.1  SWI                (at XXFC)
    _Startup, 
};


const byte NVOPT_INIT  @0x0000FFBF = 0x02;    // vector redirect, flash unsecure
const byte NVPROT_INIT @0x0000FFBD = (BOOTLOADER_START_ADDR/0x100)-2;    // 0xFC00-0xFFFF are protected 


int main()
{

  hcc_u8 tmp;
  hw_init();

  /* See in what mode should we run. */
  tmp = (hcc_u8)(SW1_ACTIVE() ? 1 : 0);
  tmp |= (hcc_u8)(SW2_ACTIVE() ? 2 : 0);




  usb_cfg_init();
  set_mode(dm_kbd);
  hid_kbd();

  /* Start the right HID application. */
/*  switch(tmp)
  {
  default:
  case 0:
    usb_cfg_init();
    set_mode(dm_mouse);
    (void)hid_mouse();
    break;
  case 1:
    usb_cfg_init();
    set_mode(dm_kbd);
    hid_kbd();
    break;
  case 2:
    usb_cfg_init();
    set_mode(dm_generic);
    hid_generic();
    break;
  }
  */
  /* We will never get here. */
  return 0;
}
/****************************** END OF FILE **********************************/
