//#pragma LINK_INFO DERIVATIVE "mc9s12p128"

/******************************************************************************
													            Copyright (c) Freescale 2009
File Name    : $RCSfile: main.c,v $

Current Revision :	$Revision: 1.0 $

PURPOSE: main program entry.                       
                                                                          
                                                                       
DESCRIPTION:  function main() providing initial program entry.
                                                         
                                                                          
UPDATE HISTORY                                                            
REV  AUTHOR    DATE        DESCRIPTION OF CHANGE                          
---  ------    --------    ---------------------                          
1.0  r28318    05/10/09    - initial coding

     *******************************************************************
     * File created by: Freescale East Kilbride MSG Applications Group *
     *******************************************************************

                                                                          
******************************************************************************/
/*===========================================================================*/
/* Freescale reserves the right to make changes without further notice to any*/
/* product herein to improve reliability, function, or design. Freescale does*/
/* not assume any  liability arising  out  of the  application or use of any */
/* product,  circuit, or software described herein;  neither  does it convey */
/* any license under its patent rights  nor the  rights of others.  Freescale*/
/* products are not designed, intended,  or authorized for use as components */
/* in  systems  intended  for  surgical  implant  into  the  body, or  other */
/* applications intended to support life, or  for any  other application  in */
/* which the failure of the Freescale product  could create a situation where*/
/* personal injury or death may occur. Should Buyer purchase or use Freescale*/
/* products for any such intended  or unauthorized  application, Buyer shall */
/* indemnify and  hold  Freescale  and its officers, employees, subsidiaries,*/
/* affiliates,  and distributors harmless against all claims costs, damages, */
/* and expenses, and reasonable  attorney  fees arising  out of, directly or */
/* indirectly,  any claim of personal injury  or death  associated with such */
/* unintended or unauthorized use, even if such claim alleges that  Freescale*/
/* was negligent regarding the  design  or manufacture of the part. Freescale*/
/* and the Freescale logo* are registered trademarks of Freescale Ltd.       */
/*****************************************************************************/

/************************* Include Files *************************************/
/*general includes */
#include <hidef.h>  /* also includes boolean definitions in stdtypes.h     */
#include <mc9s12xhy256.h>     /* derivative information */
#include "target.h" 
#include "S12HY_peripherals.h" /* includes peripherals definitions and FSL data types */


/************************* typedefs ******************************************/

/************************* #defines ******************************************/

/************************* Constants *****************************************/
#pragma CONST_SEG DEFAULT

/************************* Global Variables **********************************/
#pragma DATA_SEG DEFAULT

/************************* function prototypes *******************************/
#pragma CODE_SEG DEFAULT

void CRG_Init(void);
/************************* Functions *****************************************/
#pragma CODE_SEG DEFAULT

void CRG_Init(void)
{
   PLLCTL_CME  = 1;
   PLLCTL_SCME = 1;   
	
   REFDV = ((REFCLK_RANGE<<6) | (PLL_DIVIDER-1));    /* Reference Clock / 1 = 4MHz */
   SYNR =  ((VCO_RANGE<<6) | (PLL_MULTIPLIER-1));    /* configure the PLL  x 16 = 64MHz VCO */
   POSTDIV = (PLL_POSTDIVIDER-1);
                       /* Post divider / 1 = 32MHz Bus CLK */   
   while(!CRGFLG_LOCK)
   {
      
      /* wait for PLL to lock */
   }
   CLKSEL_PLLSEL = 1;
}

/******************************************************************************
Function Name  : main
Engineer       : r28318	
Date           : 09/06/09
Parameters     : NONE
Returns        : NONE
Notes          : main routine called by Startup.c.
                 This function configures SPI communications generating:
                 Slave Select, data transmitted on MOSI and the Serial Clock 
                 signals.
                  
******************************************************************************/


void main(void)
{
   
   char outer_delay_cntr,inner_delay_cntr;
   char data = 0;

   /* initialise the system clock - 32MHz Bus CLK, 8MHz Crystal */
   
   
	CRG_Init(); 
	 
   /* Initialise the SPI */
   SPICR2 = 0x10; /* 8-Bit transfer width; SS pin is used by the SPI */
   SPIBR =  0x77; /* SPI clock = Bus Clock divided by 2048 = 15.625kHz */
   SPICR1 = 0x56; /* SPI enabled; Master mode; Active high clocks; Slave Select output enabled*/
   

   while(1)
   {
      while(SPISR_SPTEF==0); /* Wait till transmit data register is empty*/
      SPIDRL = data++;       /* Write data to transmit data register */ 
                            /* Writing SPIDR after reading SPISR with SPTEF=1 clears SPTEF */

      /* Delay to seperate SPI transmissions */
      for (outer_delay_cntr=0; outer_delay_cntr<100; outer_delay_cntr++)
      {	
    	   for (inner_delay_cntr=0; inner_delay_cntr<100; inner_delay_cntr++);
      }
   }
}