/******************************************************************************
													            Copyright (c) Freescale 2009
File Name    : $RCSfile: main.c,v $

Current Revision :	$Revision: 1.0 $

PURPOSE: main program entry.                       
                                                                          
                                                                       
DESCRIPTION:  function main() providing initial program entry.
                                                         
                                                                          
UPDATE HISTORY                                                            
REV  AUTHOR    DATE        DESCRIPTION OF CHANGE                          
---  ------    --------    ---------------------                          
1.0  r28318    05/10/09    - initial coding
      
     *******************************************************************
     * File created by: Freescale East Kilbride MSG Applications Group *
     *******************************************************************

                                                                          
******************************************************************************/
/*===========================================================================*/
/* Freescale reserves the right to make changes without further notice to any*/
/* product herein to improve reliability, function, or design. Freescale does*/
/* not assume any  liability arising  out  of the  application or use of any */
/* product,  circuit, or software described herein;  neither  does it convey */
/* any license under its patent rights  nor the  rights of others.  Freescale*/
/* products are not designed, intended,  or authorized for use as components */
/* in  systems  intended  for  surgical  implant  into  the  body, or  other */
/* applications intended to support life, or  for any  other application  in */
/* which the failure of the Freescale product  could create a situation where*/
/* personal injury or death may occur. Should Buyer purchase or use Freescale*/
/* products for any such intended  or unauthorized  application, Buyer shall */
/* indemnify and  hold  Freescale  and its officers, employees, subsidiaries,*/
/* affiliates,  and distributors harmless against all claims costs, damages, */
/* and expenses, and reasonable  attorney  fees arising  out of, directly or */
/* indirectly,  any claim of personal injury  or death  associated with such */
/* unintended or unauthorized use, even if such claim alleges that  Freescale*/
/* was negligent regarding the  design  or manufacture of the part. Freescale*/
/* and the Freescale logo* are registered trademarks of Freescale Ltd.       */
/*****************************************************************************/

/************************* Include Files *************************************/
/*general includes */
#include <hidef.h>             /* also includes boolean definitions in stdtypes.h     */ 
#include <mc9s12xhy256.h>      /* derivative information                              */
#include "target.h" 
#include "S12HY_peripherals.h" /* includes peripherals definitions and FSL data types */


/************************* typedefs ******************************************/

/************************* #defines ******************************************/

/************************* Constants *****************************************/
#pragma CONST_SEG DEFAULT

#define CONST (BUSCLK_FREQ_KHZ / 6 /* loop cycles */ )

/************************* Global Variables **********************************/
#pragma DATA_SEG DEFAULT

/************************* function prototypes *******************************/
#pragma CODE_SEG DEFAULT

void CRG_Init(void);

/************************* Functions *****************************************/
#pragma CODE_SEG DEFAULT

/******************************************************************************
Function Name  : CRG_Init
Engineer       : b33646	
Date           : 09/11/10
Parameters     : NONE
Returns        : NONE
Notes          : This is an initialization CRG routine OSC 8MHZ - BUS 32MHZ
******************************************************************************/
void CRG_Init(void)
{
   

   PLLCTL_CME    = 1;
   PLLCTL_SCME   = 1;
	 
   REFDV         = ((REFCLK_RANGE<<6) | (PLL_DIVIDER-1)); /* Reference Clock / 1     = 4MHz      */
   SYNR          = ((VCO_RANGE<<6) | (PLL_MULTIPLIER-1)); /* configure the PLL  x 16 = 64MHz VCO */
   POSTDIV       = (PLL_POSTDIVIDER-1);                   /* Post divider / 1 = 32MHz Bus CLK    */
   CLKSEL_PLLSEL = 1;                                     /* select the PLL as the clock source  */
   
   while(!CRGFLG_LOCK)
   {
      /* wait for PLL to lock                */
   }
}

/******************************************************************************
Function Name  : main
Engineer       : r28318	
Date           : 09/06/09
Parameters     : NONE
Returns        : NONE
Notes          : main routine called by Startup.c.
                 This main routine will send messages in loopback mode, message
                 data contains EVB switches state, switch state will be 
                 received and displayed on EVB LEDs. You can monitor in the 
                 debugger CAN0RXDSR0 to monitor the received data from switches.
                  
******************************************************************************/
void main(void) 
{
   byte txbuffer;

   /* initialize the system clock - 32MHz Bus CLK, 8MHz Crystal */
	
	CRG_Init();
   	 
   /* initialize the IO */   
   
   PTR       = 0x0F;  /* Initialize PR[3:0] High; turn off LEDs    */
   DDRR      = 0x0F;  /* PR[3:0] = output; enable LEDs             */

   ATDDIENL  = 0xF0;  /* enable digital inputs on Switches         */  
   PER1AD    = 0xF0;  /* Enable pull ups on Switches                */
	 
      /* initialize the CAN */  
   CAN0CTL0  = 0x01;  /*	enter init mode                          */
   
   while(!(CAN0CTL1_INITAK));		/* wait for init mode              */

   CAN0CTL1  = 0xA0;	/* enable CAN module, Loopback Mode, Ext OSC */
   CAN0BTR0  = 0xC3;	/* sync jump - 4 Tq clocks, prescaler = 3 */
   CAN0BTR1  = 0x3A;	/* Tseg = 3, Tseg1 = 10, 1 sample per bit */
   CAN0IDAC  = 0x10;	/* four 16-bit filters */

   CAN0IDAR0 = 0x20;	/* Filter 0, ID=0x100 Standard Identifier */
   CAN0IDMR0 = 0x00;
   CAN0IDAR1 = 0x00;
   CAN0IDMR1 = 0x07;  /* AM[2:0] = 7 to receive standard identifiers */

   CAN0IDAR2 = 0x00;  /* Filter 1, ID=0x0000                         */
   CAN0IDMR2 = 0x00;
   CAN0IDAR3 = 0x00;
   CAN0IDMR3 = 0x07;  /* AM[2:0] = 7 to receive standard identifiers */

   CAN0IDAR4 = 0x00;	/* Filter 2, ID=0x0000                         */
   CAN0IDMR4 = 0x00;
   CAN0IDAR5 = 0x00;
   CAN0IDMR5 = 0x07;  /* AM[2:0] = 7 to receive standard identifiers */

   CAN0IDAR6 = 0x00;	/* Filter 3, ID=0x0000                         */
   CAN0IDMR6 = 0x00;
   CAN0IDAR7 = 0x00;
   CAN0IDMR7 = 0x07;  /* AM[2:0] = 7 to receive standard identifiers */

   CAN0CTL0  = 0x00;	/* exit init mode                              */
   
   while(CAN0CTL1_INITAK);   /* wait until module exits init mode    */
     
   while(!(CAN0CTL0_SYNCH)); /* wait for CAN module to synch         */
  
	 CAN0RFLG  = 0xC3;         /* reset Rx flags                       */

  		   
   for(;;)
   {
      while (!CAN0TFLG);      /* Wait for empty Tx Buffer            */
     
      CAN0TBSEL  = CAN0TFLG;	/* Select the empty Tx Buffer          */
      txbuffer   = CAN0TBSEL; /* Save the empty buffer               */

      CAN0TXIDR0 = 0x20;      /* load message id value to ID regs    */
      CAN0TXIDR1 = 0x00;
      CAN0TXIDR2 = 0x00;
      CAN0TXIDR3 = 0x00;

      CAN0TXDSR0 = (PT1AD);		/* load data to send                   */

      CAN0TXDLR  = 0x01;			/* set data length                     */
      CAN0TXTBPR = 0x80;		  /* set data buffer priority            */

      CAN0TFLG    = txbuffer; /* start transmission */

      while(!(CAN0TFLG & txbuffer));	/* wait for Tx to complete                         */
     
		  if(CAN0RFLG_RXF)          /* has a message been received ?                         */
		  {
		     PTR = (CAN0RXDSR0>>4); /* Map received switches information to LEDs and display */
         CAN0RFLG_RXF = 1;      /* Clear RXF */
      }

   }

}


