/******************************************************************************
Standard Definitions

These defines allow for easier porting to other compilers. if porting change
these defines to the required values for the chosen compiler.
******************************************************************************/

typedef unsigned char    tU08;   /*unsigned 8 bit definition */
typedef unsigned int    tU16;   /*unsigned 16 bit definition*/
typedef unsigned long   tU32;   /*unsigned 32 bit definition*/
typedef signed char     tS08;   /*signed 8 bit definition */
typedef signed int      tS16;   /*signed 16 bit definition*/
typedef signed long int    	  tS32;   /*signed 32 bit definition*/


#ifndef UINT8
#define	UINT8	tU08			/* unsigned 8-bit */	
#define	UINT16	tU16			/* unsigned 16-bit */
#define	UINT32	tU32			/* unsigned 32-bit */
#define	INT8	tS08			/* signed 8-bit */
#define	INT16	tS16			/* signed 16-bit */
#define	INT32	tS32			/* signed 32-bit */
#endif /* UINT8 */


#ifndef u8
#define u8 tU08
#define u16 tU16
#define u32 tU32
#define s8 tS08
#define s16 tS16
#define s32 tS32
#endif /*u8*/

#define stop()        {asm stop;}
//******************************************************************************
//common labels
#define OFF			  0
#define ON        1
#define NO			  0
#define YES       1
//#define FALSE			0
//#define TRUE      1

/************************* #defines ******************************************/
#define ALL_FULL_DRIVE		0x00   
#define ALL_REDUCED_DRIVE	0xFF

#define ALL_PULLS_OFF		  0x00
#define ALL_PULLS_ON	    0xFF

#define ALL_PULLED_UP		  0x00   
#define ALL_PULLED_DOWN		0xFF

#define ALL_INPUTS			  0x00
#define ALL_OUTPUTS			  0xFF	

#define ALL_LOW				    0x00
#define ALL_HIGH			    0xFF

#define ms_Delay_Cnt			0x1F40		// count used in Delay_1ms routine


#define menu_sw     PT1AD_PT1AD5
#define right_sw    PT1AD_PT1AD6
#define left_sw     PT1AD_PT1AD7


//#define SW1				PT1AD_PT1AD4
//#define SW2				PT1AD_PT1AD5
//#define SW3				PT1AD_PT1AD6
//#define SW4				PT1AD_PT1AD7

#define TRANSDEMO		1
#define TEMPDEMO		2
#define ODODEMO	  	4
#define FCDEMO			8

#define left_LED    PTR_PTR0
#define right_LED   PTR_PTR1

//#define LED1			PTR_PTR0
//#define LED2			PTR_PTR1
//#define LED3			PTR_PTR2
//#define LED4			PTR_PTR3

#define LOFF			0x01
#define LON				0x00

//#define LEDS_OFF		PTR_PTR0 = 1, PTR_PTR1 = 1, PTR_PTR2 = 1, PTS_PTS4;


/************************* Prototypes ****************************************/

void Configure_Ports(void);		// configure ports
void CRG_8MHz(void);
void MDelay(int delayTime);
