
MEMORY {

// 256MB of dram starting at 0x40000000

    dram_rsvd1   : ORIGIN = 0x40000000, LENGTH = 0
    dram_reset   : ORIGIN = .,	        LENGTH = 0
    dram_rsvd2   : ORIGIN = ., 	        LENGTH = 0
    dram_memory  : ORIGIN = ., 	 	LENGTH = 256k

// 3MB of flash starting at 0x00000000

    flash_rchw   : ORIGIN = 0x00000000, LENGTH = 0x10
    flash_memory : ORIGIN = .,          LENGTH = 3M-0x10
    flash_rsvd2  : ORIGIN = .,          LENGTH = 0

}

DEFAULTS {

    heap_reserve = 1k
    stack_reserve = 1K

}
//
// Program layout for starting in ROM, copying data to RAM,
// and continuing to execute out of ROM.
//

//
//   If you wish to install a reset vector handler on your system,
//   uncomment the following OPTION() directive and the reference
//   to the .reset section.
//   You may not want to do this if you are relying on preinstalled
//   firmware to initialize your system.
//
//   OPTION("-u __ghs_reset_handler")

SECTIONS
{
     //.reset                                         ABS : > dram_reset	

//
// RAM SECTIONS
//
    .PPC.EMB.sdata0 	          		    ABS : > dram_memory
    .PPC.EMB.sbss0                            CLEAR ABS : > .
   
    .sdabase 		       		       ALIGN(16): > dram_memory	
    .sdata 						: > .
    .sbss 						: > .
    .data 						: > .
    .bss 						: > .
    .heap                  ALIGN(16) PAD(heap_reserve)  : > .   
    .stack                 ALIGN(16) PAD(stack_reserve) : > .

//
// ROM SECTIONS
//

    .rchw                           : > flash_rchw
	.text    						: > flash_memory
    .vletext						: > .
    .syscall						: > .

    .rodata		 				: > .
    .sdata2 						: > .

     //the interrupt vector table for the INTC must be aligned on 2K boundary
     .isrvectbl    		   ALIGN(0x800)         : > .
     // align the IVPR on a 4K boundary */
     .intbaseaddress 	  ALIGN(0x1000)                 : > .  		
    .secinfo 						: > .
    .fixaddr 						: > .
    .fixtype 						: > .

    .CROM.PPC.EMB.sdata0 	  CROM(.PPC.EMB.sdata0) : > .
    .CROM.sdata  	            	   CROM(.sdata) : > .
    .CROM.data 	            		    CROM(.data) : > .

//
// These special symbols mark the bounds of RAM and ROM memory.
// They are used by the MULTI debugger.
//
    __ghs_ramstart  = MEMADDR(dram_rsvd1);
    __ghs_ramend    = MEMENDADDR(dram_memory);
    __ghs_romstart  = MEMADDR(flash_rchw);
    __ghs_romend    = MEMENDADDR(flash_rsvd2);

//
// These special symbols mark the bounds of RAM and ROM images of boot code.
// They are used by the GHS startup code (_start and __ghs_ind_crt0).
//
    __ghs_rambootcodestart  = 0;
    __ghs_rambootcodeend    = 0;
    __ghs_rombootcodestart  = ADDR(.text);
    __ghs_rombootcodeend    = ENDADDR(.fixtype);
    
    // Interrupt Handler jump table base address */
    __IV_ADDR     = ADDR(.intbaseaddress);
}

