################################################################
#       Initialize SRAM - 48k (0x40000000-0x4000BFFF)
################################################################

.global __ghs_board_memory_init

    .section .vletext,vax        # The "ax" generates symbols for debug, "v" for VLE  

__ghs_board_memory_init:
    .vle
	
#******************
# Enable SPE in MSR
#******************
  mfMSR r6
  e_or2is  r6, 0x0200
  mtMSR r6
	
    e_lis 	r11,0x4000              # base address of the RAM
    e_or2i 	r11, 0
	
	e_li  	r12,2048                 # loop counter to get all of 256k RAM  96*1024*8/32*32			
//    e_li  	r12,768                 # loop counter to get all of 96k RAM  96*1024*8/32*32	
//    e_li  	r12,384                 # loop counter to get all of 48k RAM  48*1024*8/32*32
//    e_li  	r12,256                 # loop counter to get all of 32k RAM  32*1024*8/32*32

     mtctr  	r12
init_loop:
    e_stmw    	r0,0(r11)           	# write all 32 registers to L2RAM
    e_add2i.  	r11, 128            	# inc the ram ptr
    e_bdnz      init_loop       	    # loop for 48k of L2RAM

    se_blr                           	# done
