/*
                    Language Independent Library

            Copyright 2006  Green Hills Software,Inc.

 *  This program is the property of Green Hills Software, Inc,
 *  its contents are proprietary information and no part of it
 *  is to be disclosed to anyone except employees of Green Hills
 *  Software, Inc., or as agreed in writing signed by the President
 *  of Green Hills Software, Inc.
*/

/* This module is meant to perform stack checking using the -stack_check
 * option.
 */

/* Get __get_stack_pointer() on appropriate targets */
#include <alloca.h>
#include "ind_io.h" /* write() */
#include <stdlib.h> /* exit() */
extern char __ghsbegin_stack[], __ghsend_stack[];

#pragma ghs startnoinline

static void emit_stack_error(void) 
{
    static const char err[] = "Stack overflow error\n";
    (void)write(2 /* stderr */, err, sizeof(err));
    /* exit is already pulled in by the default ind_crt1.c, so use it */
    exit(1);
}

void __stkchk(void)
{
#ifdef __GHS_TARGET_IMPLEMENTS_ALLOCA
    void *sp = __get_stack_pointer();
#else
    char loc;
    void *sp = (void *)&loc;
#endif /* __GHS_TARGET_IMPLEMENTS_ALLOCA */

#if defined(__StarCore__) || defined(__i960)
    /* Most targets have a stack that grows down, but these two
     * have a stack that grows up.
     */    
    if (sp >= __ghsend_stack)
#else
    if (sp <= __ghsbegin_stack)
#endif
	emit_stack_error();
}
