/*
                C++ Library

        Copyright 1983-2007 Green Hills Software,Inc.

    This program is the property of Green Hills Software, Inc,
    its contents are proprietary information and no part of it
    is to be disclosed to anyone except employees of Green Hills
    Software, Inc., or as agreed in writing signed by the President
    of Green Hills Software, Inc.
*/

/*
 * Implementation of the C++ library locks
 */

#include <stdlib.h>
#include <stdio.h>
typedef void (*vfpt)();
extern vfpt _ctors[], _dtors[];
 
void __call_dtors(void);

#if defined(__OSE)
#undef abort
#endif

#if defined(GHS_TDEH)
// [rprichard] Fri Jan  4 18:20:16 2008.  TOOLS-8200.  Note that TDEH is
// disabled in 5.x.
// trg/ppc/default.gpj sets USE_TDEH which causes
// src/edg/lib_src/lib*edge.gpj and integrity_edg_objs.gpj to set -DGHS_TDEH.
// rtos/intlib/sharedcppobjects.c is duplicated from here.  The
// src/configuration/defaults/bld_rules/ppc.bod file has a GHS_SUPPORTS_TDEH
// which allows INTEGRITY to use #ifdef GHS_TDEH, but this usage is dead now.
// [mkrebs] Thu Feb 22 20:08:41 2007  On win32 these declarations cause
// "local symbol `__ghs_uw_reg_eh_table' has no section" linker warnings
// (at least for win32-cross-linux86) because weak is not supported.
#pragma weak __ghs_uw_reg_eh_table
#pragma weak __ghsbegin_ghs_tdeh_table
#pragma weak __ghsend_ghs_tdeh_table
extern void* __ghsbegin_ghs_tdeh_table;
extern void* __ghsend_ghs_tdeh_table; 
extern "C" void __ghs_uw_reg_eh_table(void* begtable, void* endtable);
#endif

/* Initialize the static constructors using the _ctors array. Set up the call
   to __call_dtors at the exit */
extern "C" void _main()
{
    int i = 0;
    static int been_here = 0;

    if (been_here)
	return;
    been_here = 1;

/*-----------------------------*/
/* initialize TDEH             */
/*-----------------------------*/
#if defined(GHS_TDEH)
// [guyg] Tue Nov 28 10:20:45 2006 - We don't have tdeh on windows and 
// this is making all programs crash on windows.  See MULTI-18757.
// Note that this code is duplicated in rtos/intlib/sharedcppobjects.c
// -DGHS_TDEH is set in lib*edge.gpj and integrity_edg_objs.gpj
    static void (* tdeh_init_funcp)(void*, void*) = __ghs_uw_reg_eh_table;
    if (tdeh_init_funcp)
	__ghs_uw_reg_eh_table(&__ghsbegin_ghs_tdeh_table, &__ghsend_ghs_tdeh_table);
#endif

    atexit(__call_dtors);
    while (_ctors[i])
        (*_ctors[i++])();
}

#ifndef __INTEGRITY_SHARED_LIBS
/* [nikola] Fri Oct  9 16:05:18 PDT 1998 - split this into two modules for
 * INTEGRITY shared libraries. This is b/c _ctors[] array should not be part
 * of the shared library (so neither should _main()). 
 * __record_needed_destruction() and __call_dtors() however, have to be part
 * of the library, so it can link.
 *
 * The module ind_dtors.cc has the code below for INTEGRITY
 */
 

/* the following code is all for supporting destructors.  If no destructors
   exist in the application, it can all be deleted.  If exception_handling
   is enabled in the library , a stub for __call_dtors will still be needed.

   The function, __record_needed_destruction() is called from constructor
   routines generated by cxxfe.  If it is called, it indicates that there
   are some global objects which require destruction.
*/
#ifdef NO_DESTRUCTOR_SUPPORT

void __call_dtors() {}
extern "C" void __record_needed_destruction(node_type node) { }

#else

typedef struct node_type {
    struct node_type *next;
    void	*object;
    vfpt	routine;
} node_type;
typedef void (*dfpt)(void*, int);
    
static node_type *list_head;

typedef struct node_type2 {
    struct node_type2 *next;
    void              **so_id;
    void              *object;
    vfpt              routine;
} node_type2;

static node_type2 * list_head2;

#if defined(SOLARIS20) || defined(__LINUX) 
/*
Shared objects on Unix / Linux are not guaranteed to be unloaded
in the opposite order of which they were loaded. Since we use _init and _fini
to call the static constructors and destructors, we can't guarantee that
static destructors are going to be called in the reverse order of the 
constructors if more than one shared object is used. To fix that, we introduce
a list of modules, each with its own list of static destructors.

When an _init() function for a shared object is called, a module entry gets
placed on the module_head list. When a module is explicitly unloaded, it
calls its own list of destructors. When a module is automatically unloaded,
the call to __call_dtors will have called all of the destructors in the
right (reverse) order, and the modules _fini function will do nothing.
*/

typedef struct module_type {
    struct module_type *next;
    void               *module_id;
    node_type          *list_head;
} module_type;

static module_type *module_head;

extern "C" void __module_needed_destruction(module_type *module) 
/*
Push a module struct onto the module_head list.
*/
{
    if (module->next != NULL || module == module_head)
        return;
    module->next = module_head;
    module_head = module;
}  /* __module_needed_destruction */

extern "C" module_type *__remove_destruction_module(void *mod_id) 
/*
Given an module id, find the corresponding module struct, remove it
from the list, and return a pointer to it. Return NULL if there is no
corresponding module entry.
*/
{
    module_type *prev, *curr;
    prev = NULL;
    for (curr = module_head; curr != NULL; curr = curr->next) {
        if (curr->module_id == mod_id) {
	    if (prev != NULL) {
	        prev->next = curr->next;
	    } else {
	        module_head = curr->next;
	    }  /* if */
	    curr->next = NULL;
	    return curr;
	}  /* if */
    }  /* for */

    return NULL;

}  /* __remove_destruction_module */

#endif /* SOLARIS20 || __LINUX */

#if defined(__SC3__)
// Functions needed for C++ with StarCore SC3 compiler.
//   __register_global_object() is called by code generated by the SC3 compiler.
//     It registers a destructor to be called later.
//   __destroy_global_chain() is called when the program exits; we register it
//     with atexit in __ghs_ind_crt1().
//   (constructors are called by __exec_staticinit(), which is called by
//    __ghs_ind_crt1() in ind_crt1.c in libsys)
extern "C" {
    typedef struct _GlobalObjects {
	struct _GlobalObjects *next;
	void (*destructor)(void *);
	void *object;
    } _GlobalObjects;

    _GlobalObjects *__global_objects = NULL;

    void *__register_global_object(void *object, void (*destructor)(void *), void *memory)
    {
	_GlobalObjects *global_object = (_GlobalObjects *)memory;
	global_object->next = __global_objects;
	global_object->object = object;
	global_object->destructor = destructor;
	__global_objects = global_object;
	return object;
    }

    void __destroy_global_chain(void)
    {
	_GlobalObjects *global_object = __global_objects;
	while (global_object != NULL) {
	    __global_objects = global_object->next;
	    global_object->destructor(global_object->object);
	    global_object = global_object->next;
	}
    }
}
#endif /* __SC3__ */

extern "C" void __call_dtors_single_list(node_type **node_list) 
/*
The function that actually does the work of calling the destructors. node_list
is a pointer to the head of the node list. It gets overwritten as part of the
processing (with NULL, since this routine scans to the end of the list).
*/
{
    node_type *vfptr;
    while (*node_list) {
	void *objectp;

	vfptr = *node_list;
	*node_list = (*node_list)->next;
	objectp = vfptr->object;
	if (objectp) {
	    dfpt dfptr = (dfpt)vfptr->routine;
	    (dfptr)(objectp, 2);  /* 2 means destruct, but don't destroy*/
	} else {
	    (vfptr->routine)();
	}
    }
}  /* __call_dtors_single_list */

extern "C" void __call_dtors_with_so_id(void *so_id)
/*
Call all destructors associated with 'so_id', or all of them if 'so_id' is
NULL.
*/
{
    node_type2 *old_lh2, *curr, *prev;

    curr = list_head2; 
    prev = NULL;
 
    while (curr != NULL) {
        if (NULL == so_id || 
	    (curr->so_id != NULL && so_id == *(curr->so_id))) {
	    /* the entries match, or so_id was NULL - remove the object from 
	       the list, and destruct it */
	    if (NULL == prev) {
	        list_head2 = curr->next;
	    } else {
	        prev->next = curr->next;
	    }  /* if */

	    old_lh2 = list_head2;

	    if (curr->object != NULL) {
	        /* destruct, but don't destroy */
	        dfpt dfptr = (dfpt)(curr->routine);
		(dfptr)(curr->object, 2);       
	    } else {
	        (curr->routine)();
	    }  /* if */

	    if (old_lh2 != list_head2) {
	        /* items added to list during destructor call, start anew */
	        curr = list_head2;
		prev = NULL;
	    } else {
	        curr = curr->next;
	    }  /* if */

	} else {
	    /* the entry should not be removed, remember it with 'prev' so that
	       the list of remaining entries is left intact */
	    prev = curr;
	    curr = curr->next;
	}  /* if */
    }  /* while */

}  /* __call_dtors_with_so_id */


void __call_dtors()
/* 
Call the destructors pointed to by 'list_head'. Empty the list.
#if defined(SOLARIS20) || defined(__LINUX)
Also call the destructors of all of the modules on the 'module_head' list.
Empty the module_head list, and each modules local destructor list.
#endif [* SOLARIS20_ || __LINUX *]

Note that __call_dtors is not static.  It is called from ____ when 
exception handling is enabled in the library .  In that case, this 
function will be called twice, which is okay.
*/
{
    if (list_head2 != NULL) { __call_dtors_with_so_id(NULL); }
    else {
        __call_dtors_single_list(&list_head);

#if defined(SOLARIS20) || defined(__LINUX)
	while (module_head) {
	    module_type *curr_mod;

	    curr_mod = module_head;
	    module_head = module_head->next;
	    
	    __call_dtors_single_list(&(curr_mod->list_head));
	    
	}  /* while */
#endif /* SOLARIS20 || __LINUX */
    }  /* if */
}

extern "C" void __record_needed_destruction(node_type *node)
{
    if (list_head2 != NULL) {
#if !defined(__OSE)
        fprintf(stderr, "Error: detected mismatch in the "
		         "static destructor ordering strategy\n");
#endif
	abort();
    }  /* if */
    if (node->next != NULL || node == list_head) 
        return;
    node->next = list_head;
    list_head = node;
}

extern "C" void __record_needed_destruction2(node_type2 *node)
{
    if (list_head != NULL) {
#if !defined(__OSE)
        fprintf(stderr, "Error: detected mismatch in the "
		         "static destructor ordering strategy\n");
#endif
	abort();
    }  /* if */
    if (node->next != NULL || node == list_head2)
        return;
    node->next = list_head2;
    list_head2 = node;
}

#if defined(__LINUX) || defined(SOLARIS20) || defined(_WIN32)
extern "C" void * __set_needed_destruction_list(void * new_list)
{
    node_type * old_list = list_head;
    list_head = (node_type *) new_list;
    return (void *)old_list;
}
#endif /* SOLARIS20 || __LINUX || _WIN32 */

#endif /* NO_DESTRUCTOR_SUPPORT */

#endif /* !__INTEGRITY_SHARED_LIBS */

