#ifndef _PDB_FLOWTRON_H        /*prevent duplicated includes*/
#define _PDB_FLOWTRON_H

/******************************************************************************		
*                                                                                   	
*       Copyright (C) 2009 Freescale Semiconductor, Inc.                            	
*       All Rights Reserved								              				
*														              					
* Filename:       adc_flowtron.h               											
*														              					
* Description:	  16-bit ADC Header files for MC9S08GW64	        	    	   	       						
*																						
* Notes:          Based on  reference manual
*     																		
******************************************************************************/		

/******************************************************************************/

/******************************************************************************/
/* MACROS                                                                     */
/*****************************************************************************/

//Prescaler
#define PDB_PRESCALER_1   0     //peripheral clk/1
#define PDB_PRESCALER_2   1     //peripheral clk/2
#define PDB_PRESCALER_4   2     //peripheral clk/4
#define PDB_PRESCALER_8   3     //peripheral clk/8
#define PDB_PRESCALER_16  4     //peripheral clk/16
#define PDB_PRESCALER_32  5     //peripheral clk/32
#define PDB_PRESACLER_64  6     //peripheral clk/64
#define PDB_PRESCALER_128 7     //peripheral clk/128

//Mode Select
#define PDB_CONT_MODE      1       //Module in continuous mode
#define PDB_ONE_SHOT_MODE  0       //Module in One shot mode

//Input Trigger Select
#define PDB_COMP1_TRIG_SEL   0  //Comparator output 1
#define PDB_COMP2_TRIG_SEL   2  //Comparator output 2 
#define PDB_EX_TRIG_SEL      4  //External Trigger
#define PDB_SW_TRIG_SEL      7  //Software trigger 

//Interrupt enable/disable
#define PDB_IDELAY_INT_ENABLE    1   //Idelay interrupt enabled
#define PDB_IDELAY_INT_DISABLE   0   //Idelay interrupt disabled


//PDBCHxCR

#define PDB_ERR_A 0x8000;   //Sequence error on trigger A 
#define PDB_ERR_B 0x4000;   //Sequence error on trigger B

#define PDB_CHANNEL_1_TRIG_A 0
#define PDB_CHANNEL_1_TRIG_B 1
#define PDB_CHANNEL_2_TRIG_A 2
#define PDB_CHANNEL_2_TRIG_B 3
#define PDB_IDELAY_INTERRUPT 4


//functions
void PDB_Init(unsigned char,unsigned char,
              unsigned char ,unsigned char,void (*p)(unsigned char));
void PDB_Set_Mod_Idelay(unsigned int,unsigned int);
void PDB_Set_Ch1_Delay_A(unsigned int);
void PDB_Set_Ch1_Delay_B(unsigned int); 
void PDB_Set_Ch2_Delay_A(unsigned int); 
void PDB_Set_Ch2_Delay_B(unsigned int); 
void PDB_Start_SW_Trigger(void);
 
 
              
void PDB_Set_Delay(unsigned char, unsigned int,
                   unsigned int,unsigned int,
                   unsigned int); 
 
#endif