/******************************************************************************		
*                                                                                   	
*       Copyright (C) 2009 Freescale Semiconductor, Inc.                            	
*       All Rights Reserved								              				
*														              					
* Filename:       adc_flowtron.h               											
*														              					
* Description:	  16-bit ADC Header files for MC9S08GW64	        	    	   	       						
*																						
* Notes:          Based on  reference manual
*     																		
******************************************************************************/		

/******************************************************************************/

#ifndef _ADC_FLOWTRON_H        /*prevent duplicated includes*/
#define _ADC_FLOWTRON_H


/******************************************************************************/
/* Include Files                                                              */
/*****************************************************************************/


/************************* Variables *****************************************/ 
typedef union
{
  unsigned char Byte;
  struct 
    {
    unsigned char ADCHA       :5;        /* Input Channel Select */
    unsigned char DIFFA       :1;        /* Differential Mode Enable */
    unsigned char AIENA       :1;        /* Interrupt Enable */
    unsigned char COCOA       :1;        /* Conversion Complete Flag */
    } Bits;
}ADC_SC1ARegType;

typedef union
{
  unsigned char Byte;
  struct 
    {
    unsigned char ADCHB       :5;        /* Input Channel Select */
    unsigned char DIFFB       :1;        /* Differential Mode Enable */
    unsigned char AIENB       :1;        /* Interrupt Enable */
    unsigned char COCOB       :1;        /* Conversion Complete Flag */
    } Bits;
}ADC_SC1BRegType;


typedef union 
{
  unsigned char Byte;
  struct 
    {
    unsigned char ADICLK      :2;        /* Input Clock Select */
    unsigned char MODE        :2;        /* Conversion Mode Select */
    unsigned char ADLSMP      :1;        /* Sample Time Configuration */
    unsigned char ADIV        :2;        /* Clock Divide Select */
    unsigned char ADLPC       :1;        /* Low Power Configuration */
    } Bits;
}ADC_CFG1RegType;


typedef union 
{
  unsigned char Byte;
  struct 
    {
    unsigned char ADLSTS      :2;        /* Long Sample Time Select */                    
    unsigned char ADHSC       :1;        /* High Speed Configuration */
    unsigned char ADACKEN     :1;        /* Asynchronous Clock Output Enable */
    unsigned char             :4;
    } Bits;
}ADC_CFG2RegType;



typedef union 
{
  unsigned char Byte;
  struct 
    {
    unsigned char REFSEL      :2;        /* Voltage Reference Selection */
    unsigned char             :1;
    unsigned char ACREN       :1;        /* Compare Function Range Enable */
    unsigned char ACFGT       :1;        /* Compare Function Greater Than Enable */
    unsigned char ACFE        :1;        /* Compare Function Enable */
    unsigned char ADTRG       :1;        /* Conversion Trigger Select */        
    unsigned char ADACT       :1;        /* Conversion Active */
    } Bits;
}ADC_SC2RegType;

typedef union 
{
  unsigned char Byte;
  struct 
    {
    unsigned char AVGS        :2;        /* Hardware Average Select */
    unsigned char AVGE        :1;        /* Hardware Average Enable */
    unsigned char ADCO        :1;        /* Continous Conversion Enable */        
    unsigned char             :2;
    unsigned char CALF        :1;        /* Calibration Failed Flag */
    unsigned char CAL         :1;        /* Calibration */
    } Bits;
}ADC_SC3RegType;

typedef struct 
{
  union 
  {
    unsigned char Byte;
    struct 
      {
      unsigned char CLPD        :6;        /* Plus-side General Calibration */       
      unsigned char             :2; 
      } Bits;
  }CLPD;
  union 
  {
    unsigned char Byte;
    struct 
      {
      unsigned char CLPS        :6;        /* Plus-side General Calibration */        
      unsigned char             :2;
      } Bits;
  }CLPS;
  union 
  {
    unsigned short Word;
    struct 
      {
      unsigned short CLP4        :10;        /* Plus-side General Calibration */        
      unsigned short             :6;
      } Bits;
  }CLP4;
  union 
  {
    unsigned short Word;
    struct 
      {
      unsigned short CLP3        :9;        /* Plus-side General Calibration */        
      unsigned short             :7;
      } Bits;
  }CLP3;
  union 
  {
    unsigned char Byte;
    struct 
      {
      unsigned char CLP2        :8;        /* Plus-side General Calibration */
      } Bits;
  }CLP2;
  union 
  {
    unsigned char Byte;
    struct 
      {
      unsigned char CLP1        :7;        /* Plus-side General Calibration */        
      unsigned char             :1;
      } Bits;
  }CLP1;
  union 
  {
    unsigned char Byte;
    struct 
      {
      unsigned char CLP0        :6;        /* Plus-side General Calibration */        
      unsigned char             :2;
      } Bits;
  }CLP0;
}ADC_CLPRegType;

typedef struct 
{
  union 
  {
    unsigned char Byte;
    struct 
      {
      unsigned char CLMD        :6;        /* Minus-side General Calibration */        
      unsigned char             :2;
      } Bits;
  }CLMD;
  union 
  {
    unsigned char Byte;
    struct 
      {
      unsigned char CLMS        :6;        /* Minus-side General Calibration */        
      unsigned char             :2;
      } Bits;
  }CLMS;
  union 
  {
    unsigned short Word;
    struct 
      {
      unsigned short CLM4        :10;      /* Minus-side General Calibration */        
      unsigned short             :6;
      } Bits;
  }CLM4;
  union 
  {
    unsigned short Word;
    struct 
      {
      unsigned short CLM3        :9;       /* Minus-side General Calibration */        
      unsigned short             :7;
      } Bits;
  }CLM3;
  union 
  {
    unsigned char Byte;
    struct 
      {
      unsigned char CLM2         :8;       /* Minus-side General Calibration */
      } Bits;
  }CLM2;
  union 
  {
    unsigned char Byte;
    struct 
      {
      unsigned char CLM1         :7;       /* Minus-side General Calibration */        
      unsigned char              :1;
      } Bits;
  }CLM1;
  union 
  {
    unsigned char Byte;
    struct 
      {
      unsigned char CLM0         :6;       /* Minus-side General Calibration */        
      unsigned char              :2;
      } Bits;
  }CLM0;
}ADC_CLMRegType;

typedef struct 
{ 
  ADC_SC1ARegType	ADCSC1A;   /*ADC status and control register 1A */
  ADC_SC1BRegType	ADCSC1B;	 /*ADC status and control register 1B */
  ADC_CFG1RegType  ADCCFG1;  /*ADC config 1 register */
  ADC_CFG2RegType  ADCCFG2;  /*ADC config 2 register */
  unsigned short   ADCRA;    /*ADC result A register */
  unsigned short   ADCRB;    /*ADC result B register */
}ADC_L;
  
typedef struct				/*ADC datastructure	*/
 {
  
  unsigned short   ADCCV1;    /*ADC compare value A register */
  unsigned short   ADCCV2;    /*ADC compare value B register */
  ADC_SC2RegType	 ADCSC2;	  /*ADC status and control register 2 */
  ADC_SC3RegType	 ADCSC3;	  /*ADC status and control register 3 */
  unsigned short   ADCOFS;    /*ADC offset register */
  unsigned short   ADCPG;     /*ADC plus-input gain */
  unsigned short   ADCMG;     /*ADC minus-input gain */
  ADC_CLPRegType   ADCCLP;    /*ADC plus-side general calibration registers */
  unsigned char    RESERVED;  /*ADC reserved memory */
  ADC_CLMRegType   ADCCLM;    /*ADC minus-side general calibration registers */
 }ADC_U;

/************************* #Defines ******************************************/
#define ADC0_L 0x0040
#define ADC0_U 0x1840
#define ADC1_L 0x0080
#define ADC1_U 0x1900 



/*defines*/
#define ADC_0               0          //selects ADC 0
#define ADC_1               1          //selects ADC 1

#define ADC_CHANNEL_AD0     0          //selects Channel AD0
#define ADC_CHANNEL_AD1     1          //selects Channel AD1
#define ADC_CHANNEL_AD2     2          //selects Channel AD2
#define ADC_CHANNEL_AD3     3          //selects Channel AD3
#define ADC_CHANNEL_AD4     4          //selects Channel AD4
#define ADC_CHANNEL_AD5     5          //selects Channel AD5
#define ADC_CHANNEL_AD6     6          //selects Channel AD6
#define ADC_CHANNEL_AD7     7          //selects Channel AD7
#define ADC_CHANNEL_AD8     8          //selects Channel AD8
#define ADC_CHANNEL_AD9     9          //selects Channel AD9
#define ADC_CHANNEL_AD10   10          //selects Channel AD10
#define ADC_CHANNEL_AD11   11          //selects Channel AD11
#define ADC_CHANNEL_AD12   12          //selects Channel AD12
#define ADC_CHANNEL_AD13   13          //selects Channel AD13
#define ADC_CHANNEL_AD14   14          //selects Channel AD14
#define ADC_CHANNEL_AD15   15          //selects Channel AD15
  

#define ADICLK_BUS        0          //Bus Clock
#define ADICLK_BUS_2      1          //(Bus Clock)/2
#define ADICLK_ALTCLK     2          //Alternate Clock
#define ADICLK_ADACK      3          //Asynchronous Clock

#define ADIV_1            0          //Divide Ratio - 1
#define ADIV_2            1          //Divide Ratio - 2
#define ADIV_4            2          //Divide Ratio - 4
#define ADIV_8            3          //Divide Ratio - 8

#define ADC_MODE_8        0          //8 bit conversion
#define ADC_MODE_12       1          //12 bit conversion
#define ADC_MODE_10       2          //10 bit conversion
#define ADC_MODE_16       3          //16 bit conversion when single ended mode 
                                     //& 15 bit conversion if differential mode

#define ADTRG_SW          0        //Software trigger selected
#define ADTRG_HW          1        //Hardware trigger selected

#define ADCO_SINGLE       0        //single conversion 
#define ADCO_CONTINUOUS   1        //continuous conversion

#define ADC_REFSEL_EXT    0        //Default voltage reference pin pair (External pins VREFH and VREFL).
#define ADC_REFSEL_ALT    1        //Alternate reference pair (VALTH and VALTL)
#define ADC_REFSEL_BG     2        //Internal bandgap reference and associated ground reference(VBGH and VBGL).
#define ADC_REFSEL_RES    3        //Reserved - Selects default voltage reference (VREFH and VREFL) pin pair

#define ADC_CHANNEL_A     0        //selects channel A
#define ADC_CHANNEL_B     1        //selects channel B

#define ADC_AIEN_OFF          0        //disables the conversion complete interrupt
#define ADC_AIEN_ON           1        //enables the conversion complete interrupt

#define ADC_SINGLE_MODE       0        //selects the single ended mode
#define ADC_DIFF_MODE         1        //selects the differential mode

#define ADC_COMPARE_LESS      0        //configures less than the specified value
#define ADC_COMPARE_GREATER   1        //configures greater than or equal to the specified value

#define ADC_COMPARE_RANGE_DISABLED     0         //Range function disabled 
#define ADC_COMPARE_RANGE_ENABLED      1         //Range function enabled

#define ADC_AVG_SAMPLE_4             0       //4  Samples averaged
#define ADC_AVG_SAMPLE_8             1       //8  Samples averaged
#define ADC_AVG_SAMPLE_16            2       //16 Samples averaged
#define ADC_AVG_SAMPLE_32            3       //32 Samples averaged


#define VREFH 3.3
#define VREFL 0
  

#define ADC_CAL_BEGIN          0x80     //callibration active
#define ADC_CAL_OFF            0x00     //callibration over 

#define ADC_CALF_NORMAL        0x00     //callibration completed normally 
#define ADC_CALF_FAIL          0x40     //callibration failed

#define Read_ADC0_A_AnalogValue()  Read_ADC_AnalogValue(ADC_0,ADC_CHANNEL_A)
#define Read_ADC0_B_AnalogValue()  Read_ADC_AnalogValue(ADC_0,ADC_CHANNEL_B)
#define Read_ADC1_A_AnalogValue()  Read_ADC_AnalogValue(ADC_1,ADC_CHANNEL_A)
#define Read_ADC1_B_AnalogValue()  Read_ADC_AnalogValue(ADC_1,ADC_CHANNEL_B)


#define LED1 PTCD_PTCD5     //GPIO PTC5 is configured as LED1
#define LED2 PTCD_PTCD4     //GPIO PTC4 is configured as LED2
extern unsigned count_A;
extern unsigned count_B;

/*Functions*/
void ADC_Init(unsigned char ,unsigned char ,unsigned char ,unsigned char,
              unsigned char ,unsigned char , unsigned char);
unsigned char ADC_Cal(unsigned char);
void ADC_Channel_Config(unsigned char,unsigned char,unsigned char,
                        unsigned char);
void ADC_Compare_Enable(unsigned char ,unsigned char ,unsigned char,
                        unsigned int ,unsigned int); 
void ADC_Compare_Disable(unsigned char);
void ADC_Avg_Enable(unsigned char,unsigned char);
void ADC_Avg_Disable(unsigned char);
unsigned char ADC_Diff_Channel_Select(unsigned char ,unsigned char );
unsigned char ADC_Single_Channel_Select(unsigned char,unsigned char); 
void Read_ADC0_A(unsigned int*);
void Read_ADC1_A(unsigned int*);
void Read_ADC0_B(unsigned int*);
void Read_ADC1_B(unsigned int*);
float Read_ADC_AnalogValue( unsigned char,unsigned char); 

#endif
 
 
 
 
 
 
 
 
 