/*****************************************************************************/
/* FILE NAME: main.c                            COPYRIGHT (c) Freescale 2010 */
/*                                                       All Rights Reserved */
/*****************************************************************************/

/********************************* INCLUDE FILES *****************************/
#include "mpc5668.h"
#include "typedefs.h"		 		    

/********************************* Function Defs *****************************/
extern void execute_wait(void);
void enter_low_power_mode (void);
void led_on(int time_on, int pin_number);
void led_off(int time_off, int pin_number);
void setup_pin(void);

/********************************** Global Vars ******************************/
int PIN_NUMBER_STOP = 16;
int PIN_NUMBER_SLEEP = 17;						
int CLOCK_FREQ = 16000000;

/************************************* Main **********************************/
void main(void) {

 int wakeup_cnt = 0;
    
 setup_pin();

/* Configure API for Wake up */ 
 CRP.RTCC.B.CLKSEL = 0x1;                       /* 128Khz IRC as CLK Source  */
 CRP.RTCC.B.APIVAL = 0x3FF;                         /* Set Max value for API */
 CRP.PSCR.B.APIWKEN = 0x1;	             /* Select API as wake up source */
 CRP.CLKSRC.B.EN128KIRC = 1;	              /* enable 128K IRC for wake up */
 CRP.RTCC.B.APIEN = 1;                                         /* Enable API */
 CRP.RTCC.B.CNTEN = 1;                                         /* Enable RTC */

 while(1){

 led_off(100,16);
 led_on(100,16);

    /*  PA0 = 1 go to sleep mode */
    if (SIU.GPDI[0].R == 1){   
	enter_low_power_mode();
	
	/* Will return to Here after Sleep Mode */
	wakeup_cnt++;

        /* Clear sleep flags to allow pads to operate */
        CRP.PSCR.B.SLEEPF = 0x1;

	/* Reconfig Pins - SIU Reset after Sleep */
	setup_pin();
    }
    
 }/* End of while */  
}/* end of main() */	

/********************************** ELPM *************************************/
void enter_low_power_mode (void) {

    CRP.PSCR.B.SLEEP = 1;                     /* Confirm Sleep Mode Required */
	
    CRP.Z6VEC.B.Z6VECB = 0x00000;                    /* Write Z6VEC register */
    CRP.Z6VEC.B.VLE = 0x0;                                    /* set for VLE */
  
    SIU.HLT0.R = 0x037FFF3D;            /* Halt all modules except Z1 and Z0 */
    SIU.HLT1.R = 0x18000F3C;            /* Halt all modules except Z1 and Z0 */

    /* Wait for Halt to Complete */
    while((SIU.HLTACK0.R != 0x037FFF3D) && (SIU.HLTACK1.R != 0x18000F3C));

    CRP.PSCR.B.RAMSEL = 0x3;	/* All RAMs maintained to recover from SLEEP */
    CRP.RECPTR.B.FASTREC = 0x0;
    
    CRP.Z0VEC.B.Z0RST = 1;                                /* Put Z0 in reset */
    SIU.SYSCLK.B.SYSCLKSEL = 0;	         /* Switch system clock to 16MHz IRC */
    FMPLL.ESYNCR1.B.CLKCFG = 0;                               /* Disable PLL */
    CRP.PSCR.B.WKCLKSEL = 0x1;               /* 16MHz IRC Used for wake edge */ 

    SIU.PCR[16].R = 0x3;             /* Pull up enabled due to connected LED */
    SIU.PCR[17].R = 0x3;             /* Pull up enabled due to connected LED */

    execute_wait(); 
}


/*****************************************************************************/
/* FUNCTION     : led_on                                                     */
/* PURPOSE      : Drives the output pin to 0 (LED on) for a time defined     */
/*		  by the parameter "time_on".				     */
/*****************************************************************************/
void led_on(int time_on, int pin_number)
{
 int x = 0;
	 
 SIU.GPDO[pin_number].R = 0x0;
 time_on = (CLOCK_FREQ * time_on)/10000;
	
 for(x=0; x<time_on; x++)
 {
   asm("nop");
 }
	
 //SIU.GPDO[pin_number].R = 0x1;
 time_on = 0;
}


/*****************************************************************************/
/* FUNCTION : led_off                                                        */
/* PURPOSE  : Drives the output pin to 1 (LED off) for a time defined        */
/*				  by the parameter "time_off".               */
/*****************************************************************************/
void led_off(int time_off, int pin_number)
{
	int x = 0;
	
	SIU.GPDO[pin_number].R = 0x1;
	time_off = (CLOCK_FREQ * time_off)/10000;
	
	for(x=0; x<time_off; x++)
	{
		asm("nop");
	}
	time_off = 0;
}


/*****************************************************************************/
/* FUNCTION     : setup_pin                                                  */
/* PURPOSE      : Configures the PCR settings for the pins used in this	     */
/*                test.                                                      */
/*****************************************************************************/
void setup_pin(){
    
/* PA0 Input for Sleep Entry */
 SIU.PCR[0].R = 0x0102;

/* PB0 & PB1 For signal LED's */	
 SIU.PCR[16].R = 0x303;
 SIU.PCR[17].R = 0x303;
 
}
