/***************************************************************************//*!
*
*	Freescale Semiconductor Inc.
*	(c) Copyright 2010 Freescale Semiconductor Inc.
*	ALL RIGHTS RESERVED.
*
********************************************************************************
*
*	@file sci_app_02.h
*	
*	@version 0.0.1.0
*	
*	@lastmodusr B16958
*	
*	@lastmoddate May-18-2010
*	
********************************************************************************
*
*	@brief eDMA emulating multiple SCI transmits
*
*	This example demonstates how the eDMA could be used to emulate SCI.
*	Sending a string of bytes using chaining two eDMA channels
*	Configuration:
*		* DMA channel 0 writes to GPIO PCR_18 (PB2)
*		* DMA channel 0 activated using periodic triggers
*		* DMA channel 1 takes one byte from buffers and link to the channel 0
*		* DMA channel 1 activated explicitely by SW to transmit burst of bytes
*		* Connection: Standard wiring on EVB: PB2 and PB3 -> SCI transciever
*	
*	@project ANN-xxxx
*	
*	@author B16958
*	
*	@ingroup sci_tx
*
******************************************************************************/
#ifndef SCI_APP_02_H
#define SCI_APP_02_H

/******************************************************************************
* External Function Declarations
******************************************************************************/
extern void SciApp02(void);

#endif /* SCI_APP_02_H */