#/*******************************************************************************
#*
#*	Freescale Semiconductor Inc.
#*	(c) Copyright 2010 Freescale Semiconductor Inc.
#*	ALL RIGHTS RESERVED.
#*
#****************************************************************************//*!
#*
#*	@file vector.s
#*	
#*	@version 0.0.1.0
#*	
#*	@lastmodusr B16958
#*	
#*	@lastmoddate May-31-2010
#*	
#*	@brief Core Vector Table and Hardware Vector Mode Interrupt Vector Table
#*	
#********************************************************************************/

    .set COMPILER_GHS,  0
    .set COMPILER_DIAB, 1
    .set COMPILER_CW,   2
    
    .include "compiler_used.s"

    .if COMPILER_USED == COMPILER_GHS
		.set C_GHS,  1         # 0/1 - off/on 
		.set C_DIAB, 0         # 0/1 - off/on 
		.set C_CW,   0         # 0/1 - off/on
	.else 
	.if COMPILER_USED == COMPILER_DIAB
		.set C_GHS,  0         # 0/1 - off/on 
		.set C_DIAB, 1         # 0/1 - off/on 
		.set C_CW,   0         # 0/1 - off/on
	.else
	.if COMPILER_USED == COMPILER_CW
		.set C_GHS,  0         # 0/1 - off/on 
		.set C_DIAB, 0         # 0/1 - off/on 
		.set C_CW,   1         # 0/1 - off/on
	.endif
	.endif
	.endif
	
    # set reset configuration half word
    .set RCW, 0x015a0000
    
    # put reset configuration halfword and application start address into .rcw
    # section
    .if C_CW == 1
	.extern __start
	.section .rcw,text
	.long RCW, __start
    .else
        .extern _start
        .section ".rcw","ax"
        .long RCW, _start
    .endif

    # put remaining code in this file into .isrvectbl section,  
    # .isrvectbl section must be aligned on 0x1000 boundary in linker command
    # file since the upper 20 bits of .isrvectbl address are used to init IVPR
     .if C_GHS == 1
        .vle
        .section ".isrvectbl","avx"
     .endif

     .if C_DIAB == 1
        .section ".isrvectbl","ax"
     .endif 

     .if C_CW == 1
        .section .isrvectbl_cw,text_vle
     .endif

  # define symbols as global to allow easier debugging
	.globl critical_input_int_handler
	.globl machine_check_int_handler
	.globl data_storage_int_handler
	.globl inst_storage_int_handler
	.globl external_input_int_handler
	.globl alignment_int_handler
	.globl program_int_handler
	.globl FP_unavailable_int_handler
	.globl system_call_int_handler
	.globl AP_unavailable_int_handler
	.globl decrementer_int_handler
	.globl FIT_int_handler
	.globl watchdog_int_handler
	.globl data_TLB_error_int_handler
	.globl inst_TLB_error_int_handler
	.globl debug_int_handler
	.globl IntcVectorTableHw
	.globl CoreVectorTable

# core vector table
CoreVectorTable:
critical_input_int_handler:
	e_b .					# IVOR0
	e_b .
	e_b .
	e_b .
machine_check_int_handler:
	e_b .					# IVOR1
	e_b .
	e_b .
	e_b .
data_storage_int_handler:
	e_b .					# IVOR2
	e_b .
	e_b .
	e_b .
inst_storage_int_handler:
	e_b .					# IVOR3
	e_b .
	e_b .
	e_b .
external_input_int_handler:
	e_b .					# IVOR4
	e_b .
	e_b .
	e_b .
alignment_int_handler:
	e_b .					# IVOR5
	e_b .
	e_b .
	e_b .
program_int_handler:
	e_b .					# IVOR6
	e_b .
	e_b .
	e_b .
FP_unavailable_int_handler:
	e_b .					# IVOR7
	e_b .
	e_b .
	e_b .
system_call_int_handler:
	e_b .					# IVOR8
	e_b .
	e_b .
	e_b .
AP_unavailable_int_handler:
	e_b .					# IVOR9
	e_b .
	e_b .
	e_b .
decrementer_int_handler:
	e_b .					# IVOR10
	e_b .
	e_b .
	e_b .
FIT_int_handler:
	e_b .					# IVOR11
	e_b .
	e_b .
	e_b .
watchdog_int_handler:
	e_b .					# IVOR12
	e_b .
	e_b .
	e_b .
data_TLB_error_int_handler:
	e_b .					# IVOR13
	e_b .
	e_b .
	e_b .
inst_TLB_error_int_handler:
	e_b .					# IVOR14
	e_b .
	e_b .
	e_b .
debug_int_handler:
	e_b .					# IVOR15
	e_b .
	e_b .
	e_b .

# dummy code up to IVPR+0x800
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .
	e_b .

# intc vector table for HW vector mode at IVPR+0x800
IntcVectorTableHw:
	e_b .		# interrupt vector 0
	e_b .		# interrupt vector 1
	e_b .		# interrupt vector 2
	e_b .		# interrupt vector 3
	e_b .		# interrupt vector 4
	e_b .		# interrupt vector 5
	e_b .		# interrupt vector 6
	e_b .		# interrupt vector 7
	e_b .		# interrupt vector 8
	e_b .		# interrupt vector 9
	e_b .		# interrupt vector 10
	e_b .		# interrupt vector 11
	e_b .		# interrupt vector 12
	e_b .		# interrupt vector 13
	e_b .		# interrupt vector 14
	e_b .		# interrupt vector 15
	e_b .		# interrupt vector 16
	e_b .		# interrupt vector 17
	e_b .		# interrupt vector 18
	e_b .		# interrupt vector 19
	e_b .		# interrupt vector 20
	e_b .		# interrupt vector 21
	e_b .		# interrupt vector 22
	e_b .		# interrupt vector 23
	e_b .		# interrupt vector 24
	e_b .		# interrupt vector 25
	e_b .		# interrupt vector 26
	e_b .		# interrupt vector 27
	e_b .		# interrupt vector 28
	e_b .		# interrupt vector 29
	e_b .		# interrupt vector 30
	e_b .		# interrupt vector 31
	e_b .		# interrupt vector 32
	e_b .		# interrupt vector 33
	e_b .		# interrupt vector 34
	e_b .		# interrupt vector 35
	e_b .		# interrupt vector 36
	e_b .		# interrupt vector 37
	e_b .		# interrupt vector 38
	e_b .		# interrupt vector 39
	e_b .		# interrupt vector 40
	e_b .		# interrupt vector 41
	e_b .		# interrupt vector 42
	e_b .		# interrupt vector 43
	e_b .		# interrupt vector 44
	e_b .		# interrupt vector 45
	e_b .		# interrupt vector 46
	e_b .		# interrupt vector 47
	e_b .		# interrupt vector 48
	e_b .		# interrupt vector 49
	e_b .		# interrupt vector 50
	e_b .		# interrupt vector 51
	e_b .		# interrupt vector 52
	e_b .		# interrupt vector 53
	e_b .		# interrupt vector 54
	e_b .		# interrupt vector 55
	e_b .		# interrupt vector 56
	e_b .		# interrupt vector 57
	e_b .		# interrupt vector 58
	e_b .		# interrupt vector 59
	e_b .		# interrupt vector 60
	e_b .		# interrupt vector 61
	e_b .		# interrupt vector 62
	e_b .		# interrupt vector 63
	e_b .		# interrupt vector 64
	e_b .		# interrupt vector 65
	e_b .		# interrupt vector 66
	e_b .		# interrupt vector 67
	e_b .		# interrupt vector 68
	e_b .		# interrupt vector 69
	e_b .		# interrupt vector 70
	e_b .		# interrupt vector 71
	e_b .		# interrupt vector 72
	e_b .		# interrupt vector 73
	e_b .		# interrupt vector 74
	e_b .		# interrupt vector 75
	e_b .		# interrupt vector 76
	e_b .		# interrupt vector 77
	e_b .		# interrupt vector 78
	e_b .		# interrupt vector 79
	e_b .		# interrupt vector 80
	e_b .		# interrupt vector 81
	e_b .		# interrupt vector 82
	e_b .		# interrupt vector 83
	e_b .		# interrupt vector 84
	e_b .		# interrupt vector 85
	e_b .		# interrupt vector 86
	e_b .		# interrupt vector 87
	e_b .		# interrupt vector 88
	e_b .		# interrupt vector 89
	e_b .		# interrupt vector 90
	e_b .		# interrupt vector 91
	e_b .		# interrupt vector 92
	e_b .		# interrupt vector 93
	e_b .		# interrupt vector 94
	e_b .		# interrupt vector 95
	e_b .		# interrupt vector 96
	e_b .		# interrupt vector 97
	e_b .		# interrupt vector 98
	e_b .		# interrupt vector 99
	e_b .		# interrupt vector 100
	e_b .		# interrupt vector 101
	e_b .		# interrupt vector 102
	e_b .		# interrupt vector 103
	e_b .		# interrupt vector 104
	e_b .		# interrupt vector 105
	e_b .		# interrupt vector 106
	e_b .		# interrupt vector 107
	e_b .		# interrupt vector 108
	e_b .		# interrupt vector 109
	e_b .		# interrupt vector 110
	e_b .		# interrupt vector 111
	e_b .		# interrupt vector 112
	e_b .		# interrupt vector 113
	e_b .		# interrupt vector 114
	e_b .		# interrupt vector 115
	e_b .		# interrupt vector 116
	e_b .		# interrupt vector 117
	e_b .		# interrupt vector 118
	e_b .		# interrupt vector 119
	e_b .		# interrupt vector 120
	e_b .		# interrupt vector 121
	e_b .		# interrupt vector 122
	e_b .		# interrupt vector 123
	e_b .		# interrupt vector 124
	e_b .		# interrupt vector 125
	e_b .		# interrupt vector 126
	e_b .		# interrupt vector 127
	e_b .		# interrupt vector 128
	e_b .		# interrupt vector 129
	e_b .		# interrupt vector 130
	e_b .		# interrupt vector 131
	e_b .		# interrupt vector 132
	e_b .		# interrupt vector 133
	e_b .		# interrupt vector 134
	e_b .		# interrupt vector 135
	e_b .		# interrupt vector 136
	e_b .		# interrupt vector 137
	e_b .		# interrupt vector 138
	e_b .		# interrupt vector 139
	e_b .		# interrupt vector 140
	e_b .	        # interrupt vector 141
	e_b .		# interrupt vector 142
	e_b .		# interrupt vector 143
	e_b .		# interrupt vector 144
	e_b .		# interrupt vector 145
	e_b .		# interrupt vector 146
	e_b .		# interrupt vector 147
	e_b .		# interrupt vector 148
	e_b .		# interrupt vector 149
	e_b .		# interrupt vector 150
	e_b .		# interrupt vector 151
	e_b .		# interrupt vector 152
	e_b .		# interrupt vector 153
	e_b .           # interrupt vector 154
	e_b .		# interrupt vector 155
	e_b .		# interrupt vector 156
	e_b .		# interrupt vector 157
	e_b .		# interrupt vector 158
	e_b .		# interrupt vector 159
	e_b .		# interrupt vector 160
	e_b .		# interrupt vector 161
	e_b .		# interrupt vector 162
	e_b .		# interrupt vector 163
	e_b .	        # interrupt vector 164
	e_b .		# interrupt vector 165
	e_b .		# interrupt vector 166
	e_b .		# interrupt vector 167
	e_b .		# interrupt vector 168
	e_b .		# interrupt vector 169
	e_b .		# interrupt vector 170
	e_b .		# interrupt vector 171
	e_b .		# interrupt vector 172
	e_b .		# interrupt vector 173
	e_b .		# interrupt vector 174
	e_b .		# interrupt vector 175
	e_b .		# interrupt vector 176
	e_b .		# interrupt vector 177
	e_b .		# interrupt vector 178
	e_b .		# interrupt vector 179
	e_b .		# interrupt vector 180
	e_b .		# interrupt vector 181
	e_b .		# interrupt vector 182
	e_b .		# interrupt vector 183
	e_b .		# interrupt vector 184
	e_b .		# interrupt vector 185
	e_b .		# interrupt vector 186
	e_b .		# interrupt vector 187
	e_b .		# interrupt vector 188
	e_b .		# interrupt vector 189
	e_b .		# interrupt vector 190
	e_b .		# interrupt vector 191
	e_b .		# interrupt vector 192
	e_b .		# interrupt vector 193
	e_b .		# interrupt vector 194
	e_b .		# interrupt vector 195
	e_b .		# interrupt vector 196
	e_b .		# interrupt vector 197
	e_b .		# interrupt vector 198
	e_b .		# interrupt vector 199
	e_b .		# interrupt vector 200
	e_b .		# interrupt vector 201
	e_b .		# interrupt vector 202
	e_b .		# interrupt vector 203
	e_b .		# interrupt vector 204
	e_b .		# interrupt vector 205
	e_b .		# interrupt vector 206
	e_b .		# interrupt vector 207
	e_b .		# interrupt vector 208
	e_b .		# interrupt vector 209
	e_b .		# interrupt vector 210
	e_b .		# interrupt vector 211
	e_b .		# interrupt vector 212
	e_b .		# interrupt vector 213
	e_b .		# interrupt vector 214
	e_b .		# interrupt vector 215
	e_b .		# interrupt vector 216
