################################################################################
# Freescale Semiconductor Inc.
# (c) Copyright 2010 Freescale Semiconductor Inc.
# ALL RIGHTS RESERVED.
#############################################################################/*!
#
#	@file startup_cw.s
#
#	@version 1.0.1.0
#
#	@lastmodusr B16958
#
#	@lastmoddate Jul-1-2010
#
#	@brief MPC5604B Startup Code VLE
#
#	@project AN4147
#
##############################################################################*/

    .global __start
    .extern main	     # Defined in main.c
    .extern __STACK_SIZE     # Defined in the linker file
    .extern __SP_INIT        # Defined in the linker file
    .extern __SP_END         # Defined in the linker file
    .extern __SRAM_LOAD      # Defined in the linker file
    .extern __SRAM_LOAD_SIZE # Defined in the linker file
    .extern __IV_ADDR        # Defined in the linker file
    .extern INT_SRAM_SIZE    # Defined in the linker file
    .extern INT_SRAM_START   # Defined in the linker file
    .extern SBSS_SRAM_SIZE   # Defined in the linker file
    .extern SBSS_SRAM_START  # Defined in the linker file
    .extern BSS_SRAM_SIZE    # Defined in the linker file
    .extern BSS_SRAM_START   # Defined in the linker file
    .extern SDATA_RO_START   # Defined in the linker file
    .extern SDATA_RW_START   # Defined in the linker file 
    .extern RC_PPC_SDATA2_SIZE # Defined in the linker file 
    .extern RC_PPC_SDATA2_SRC  # Defined in the linker file 
    .extern RC_PPC_SDATA2_DEST # Defined in the linker file
    .extern RC_SDATA_SIZE # Defined in the linker file 
    .extern RC_SDATA_SRC  # Defined in the linker file 
    .extern RC_SDATA_DEST # Defined in the linker file
    .extern RC_DATA_SIZE # Defined in the linker file 
    .extern RC_DATA_SRC  # Defined in the linker file 
    .extern RC_DATA_DEST # Defined in the linker file

.section .init_cw,text_vle   # The "text" generates symbols for debug

     __start:

    xor  r0, r0, r0
    xor  r1, r1, r1
    xor  r2, r2, r2
    xor  r3, r3, r3
    xor  r4, r4, r4
    xor  r5, r5, r5
    xor  r6, r6, r6
    xor  r7, r7, r7
    xor  r8, r8, r8
    xor  r9, r9, r9
    xor  r10, r10, r10
    xor  r11, r11, r11
    xor  r12, r12, r12
    xor  r13, r13, r13
    xor  r14, r14, r14
    xor  r15, r15, r15
    xor  r16, r16, r16
    xor  r17, r17, r17
    xor  r18, r18, r18
    xor  r19, r19, r19
    xor  r20, r20, r20
    xor  r21, r21, r21
    xor  r22, r22, r22
    xor  r23, r23, r23
    xor  r24, r24, r24
    xor  r25, r25, r25
    xor  r26, r26, r26
    xor  r27, r27, r27
    xor  r28, r28, r28
    xor  r29, r29, r29
    xor  r30, r30, r30
    xor  r31, r31, r31

#/* Initialize IVPR register to address of Interrupt Vector Table */

     e_lis r5, __IV_ADDR@h 
     e_or2i  r5,__IV_ADDR@l 
     mtIVPR r5


     e_lis   r1, __SP_INIT@h
     e_or2i    r1, __SP_INIT@l

.ifndef SINTRAM    #/* SINTRAM defined by compiler option -DSINTRAM only for INTRAM build */
      e_lis   r5, INT_SRAM_SIZE@h     #/* Number of 128 byte segments */
      e_or2i    r5, INT_SRAM_SIZE@l #/* Number of 128 byte segments */
      se_mtctr r5                       #/* configure control register for use with e_bdnz */

#/* start address of the internal SRAM */
      e_lis   r5,INT_SRAM_START@h
      e_or2i    r5, INT_SRAM_START@l

#/* Repeat */
     sram_loop:
      e_stmw  r0,0(r5) #/* write all 32 registers to L2RAM */
      e_addi  r5,r5,128 #/* increment the ram ptr */
      e_bdnz   sram_loop #/* loop for 64k of L2RAM */
.endif

#/************************/
#/* Erase ".sbss Section" */
#/************************/
      e_lis  r5, SBSS_SRAM_SIZE@h       #/* Number of words */
      e_or2i   r5, SBSS_SRAM_SIZE@l   #/* Number of words */
      or.  r5, r5, r5                 #/* Number of words */
      e_beq    sram_erase1
      se_mtctr r5                        #/* configure control register for use with e_bdnz */

#/* start address of the sbss section */
      e_lis   r5,SBSS_SRAM_START@h
      e_or2i    r5, SBSS_SRAM_START@l
      xor   r0, r0, r0 
      e_subi  r5,r5,4                   #/* decrement by 4 to prepare for e_stwu in loop */

#/* Repeat */
     sram_loop1:
      e_stwu   r0,4(r5)                 #/* write 0 to RAM and update r5 address */
      e_bdnz   sram_loop1
     sram_erase1:

#/************************/
#/* Erase ".bss Section" */
#/************************/
      e_lis   r5, BSS_SRAM_SIZE@h      #/* Number of words */
      e_or2i    r5, BSS_SRAM_SIZE@l  #/* Number of words */
      or.   r5, r5, r5               #/* Number of words */
      e_beq   sram_erase2
      se_mtctr r5                       #/* configure control register for use with e_bdnz */

#/* start address of the bss section */
      e_lis   r5, BSS_SRAM_START@h
      e_or2i    r5, BSS_SRAM_START@l
      e_subi  r5,r5,4                   #/* decrement by 4 to prepare for e_stwu in loop */

#/* Repeat */
     sram_loop2:
      e_stwu r0,4(r5)                  #/* write 0 to RAM and update r5 address, r0 must be zero */
      e_bdnz   sram_loop2
     sram_erase2:

#/******************************************************************/
#/* Copy  initialized data from Flash to SRAM                      */
#/******************************************************************/
#/*******************/
#/* .PPC.EMB.sdata0 */
#/*******************/
      e_lis   r5, RC_PPC_SDATA2_SIZE@h      #/* Number of words */
      e_or2i    r5, RC_PPC_SDATA2_SIZE@l  #/* Number of words */
      or.   r5, r5, r5                     #/* Number of words */
      e_beq   data_copy1
      se_mtctr r5                       #/* configure control register for use with e_bdnz */

#/* source address of the section */
      e_lis   r8, RC_PPC_SDATA2_SRC@h
      e_or2i    r8, RC_PPC_SDATA2_SRC@l
      e_subi  r8,r8,4                   #/* decrement by 4 to prepare for e_stwu in loop */

#/* Destination address of the section */
      e_lis   r9, RC_PPC_SDATA2_DEST@h
      e_or2i    r9, RC_PPC_SDATA2_DEST@l
      e_subi  r9,r9,4                   #/* decrement by 4 to prepare for e_stwu in loop */

#/* Repeat */
     data_copy_loop1:
      e_lwzu  r10,4(r8)
      e_stwu  r10,4(r9)
      e_bdnz  data_copy_loop1
    data_copy1:
#/**********/
#/* .sdata */
#/**********/
      e_lis   r5, RC_SDATA_SIZE@h      #/* Number of words */
      e_or2i    r5, RC_SDATA_SIZE@l      #/* Number of words */
      or.   r5, r5, r5                     #/* Number of words */
      e_beq   data_copy2
      se_mtctr r5                       #/* configure control register for use with e_bdnz */

#/* source address of the section */
      e_lis   r8, RC_SDATA_SRC@h
      e_or2i    r8, RC_SDATA_SRC@l
      e_subi  r8,r8,4                   #/* decrement by 4 to prepare for e_stwu in loop */

#/* Destination address of the section */
      e_lis   r9, RC_SDATA_DEST@h
      e_or2i    r9, RC_SDATA_DEST@l
      e_subi  r9,r9,4                   #/* decrement by 4 to prepare for e_stwu in loop */

#/* Repeat */
     data_copy_loop2:
      e_lwzu  r10,4(r8)
      e_stwu  r10,4(r9)
      e_bdnz  data_copy_loop2
     data_copy2:
#/**********/
#/* .data */
#/**********/
      e_lis   r5, RC_DATA_SIZE@h      #/* Number of words */
      e_or2i    r5, RC_DATA_SIZE@l      #/* Number of words */
      or.   r5, r5, r5                     #/* Number of words */
      e_beq   data_copy3
      se_mtctr r5                       #/* configure control register for use with e_bdnz */

#/* source address of the section */
      e_lis   r8, RC_DATA_SRC@h
      e_or2i    r8, RC_DATA_SRC@l
      e_subi  r8,r8,4                   #/* decrement by 4 to prepare for e_stwu in loop */

#/* Destination address of the section */
      e_lis   r9, RC_DATA_DEST@h
      e_or2i    r9, RC_DATA_DEST@l
      e_subi  r9,r9,4                   #/* decrement by 4 to prepare for e_stwu in loop */

#/* Repeat */
     data_copy_loop3:
      e_lwzu  r10,4(r8)
      e_stwu  r10,4(r9)
      e_bdnz  data_copy_loop3
     data_copy3:

#/*********************************/
#/* Set the small ro data pointer */
#/*********************************/
      e_lis   r2, SDATA_RO_START@h
      e_or2i    r2, SDATA_RO_START@l

#/*********************************/
#/* Set the small rw data pointer */
#/*********************************/
      e_lis   r13, SDATA_RW_START@h
      e_or2i    r13, SDATA_RW_START@l

#/******************************************************************/
#/* Call Main Routine                                              */
#/******************************************************************/
     #/* Prepare a terminating stack record. */
      e_li r0, -1
      e_stwu r1, -8(r1) #/* Decrement stack by 8 bytes, (write word) */
      e_stw  r0, 4(r1)  #/* Make an illegal return address of 0xFFFFFFFF */
      e_stw  r0, 0(r1)  #/* Make an illegal back chain address of 0xFFFFFFFF */

     e_bl main

