/* +FHDR-----------------------------------------------------------------------
* Copyright (c) 2011, Freescale Semiconductor, Inc.
* ----------------------------------------------------------------------------
* FILE NAME : status.h
* AUTHOR    : Freescale Semiconductor, Inc.
* ----------------------------------------------------------------------------
* RELEASE HISTORY
* VERSION DATE AUTHOR DESCRIPTION
* (1.0) 11/01/2011   B32599 (Initial Template)
* ----------------------------------------------------------------------------
* KEYWORDS : Xtrinsic
* ----------------------------------------------------------------------------
* PURPOSE:
* ----------------------------------------------------------------------------
* REUSE ISSUES
*
* -FHDR-----------------------------------------------------------------------
*/


#ifndef STATUS_H_
#define STATUS_H_


/******************************************************************************
*******************************************************************************
*                             Status 					                      *
*******************************************************************************
*******************************************************************************/


/******************************************************************************
* Public Macros
*******************************************************************************/

#define SR_0				0			/* index of Status Register configuration */
#define SR_1				1			/* index of Status Register configuration */
#define SR_2				2			/* index of Status Register configuration */
#define SR_3				3			/* index of Status Register configuration */
#define SR_4				4			/* index of Status Register configuration */
#define SR_5				5			/* index of Status Register configuration */
#define SR_6				6			/* index of Status Register configuration */
#define SR_7				7			/* index of Status Register configuration */
#define NUMS_OF_SR			8			/* number of Status Registers */


/******************************************************************************
* Public type definitions
*******************************************************************************/

/* ----------------------------------------------------------------------------
 * Status register parameter structure
 * ----------------------------------------------------------------------------*/

typedef struct sr_app_tag
{
    uint8_t app_id;
    uint8_t output_bit_id;
}sr_app_t;


typedef struct sr_param_tag
{
	sr_app_t	sr[NUMS_OF_SR];
}sr_param_t;


/* ----------------------------------------------------------------------------
 * Status register output structure
 * ----------------------------------------------------------------------------*/

typedef struct sr_MSB_tag
{
	uint8_t Byte;
	union{
		uint8_t Rsvd			:6;
		uint8_t DataReay		:1;
		uint8_t CommandComplete	:1;
	}bits;
}sr_MSB_t;

typedef struct sr_LSB_tag
{
	uint8_t Byte;
	union{
		uint8_t PL_BAFRO			:2;
		uint8_t PL_LAPO				:3;
		uint8_t Rsvd				:1;
		uint8_t PL_Ztile_Lockout	:1;
		uint8_t	Rsvd1				:1;
	}bits;
}sr_LSB_t;

typedef struct sr_outs_tag
{
	sr_MSB_t	sr_MSB;
	sr_LSB_t	sr_LSB;
}sr_outs_t;


/* ----------------------------------------------------------------------------
 * Status register structure
 * ----------------------------------------------------------------------------*/

typedef struct sr_struct_tag
{
	sr_outs_t	outs;
	sr_param_t	param;
}sr_struct_t;




#endif /* STATUS_H_ */
