/* +FHDR-----------------------------------------------------------------------
* Copyright (c) 2011, Freescale Semiconductor, Inc.
* ----------------------------------------------------------------------------
* FILE NAME : sleep_wake.h
* AUTHOR    : Freescale Semiconductor, Inc. 
* ----------------------------------------------------------------------------
* RELEASE HISTORY
* VERSION DATE AUTHOR DESCRIPTION
* (1.0) 11/01/2011   B32599 (Initial Template)
* ----------------------------------------------------------------------------
* KEYWORDS : Xtrinsic
* ----------------------------------------------------------------------------
* PURPOSE: 
* ----------------------------------------------------------------------------
* REUSE ISSUES
*  
* -FHDR-----------------------------------------------------------------------
*/


#ifndef SLEEP_WAKE_H_
#define SLEEP_WAKE_H_


/******************************************************************************
*******************************************************************************
*                             Sleep / Wake Power Management				                          *
*******************************************************************************
*******************************************************************************/

/******************************************************************************
* Public Macros
*******************************************************************************/



/******************************************************************************
* Public type definitions
*******************************************************************************/

/* ----------------------------------------------------------------------------
 * SLEEP/WAKE parameter structure
 * ----------------------------------------------------------------------------*/	

typedef union{
	uint8_t Byte;
	struct {
		uint8_t stop_nc_en  :1;
		uint8_t fle_en      :1;
		uint8_t chnge_sched :1;
		uint8_t irq_int_en  :1;
		uint8_t stop_disable:1;
		uint8_t unused      :3;
	}bits;  
}pc_cfg_t;

typedef struct power_int_data_tag{
	uint16_t 	thresh;
	uint16_t 	max_count;
	uint8_t 	time_long_off;
	uint8_t 	time_short_off;
	pc_cfg_t 	pc_cfg;  
}power_param_t;

/* ----------------------------------------------------------------------------
 * SLEEP/WAKE output structure
 * ----------------------------------------------------------------------------*/	

typedef union power_out_data_tag{
	uint8_t scheduler_mode;
	struct {
		uint8_t MODE: 2;
		uint8_t	Rsvd: 6;
	}bits;
}power_outs_t;

/* ----------------------------------------------------------------------------
 * SLEEP/WAKE structure
 * ----------------------------------------------------------------------------*/	

typedef struct power_data_tag{
	power_outs_t	outs;
	power_param_t	param;
}power_struct_t;


#endif /* SLEEP_WAKE_H_ */

