/* +FHDR-----------------------------------------------------------------------
* Copyright (c) 2011, Freescale Semiconductor, Inc.
* ----------------------------------------------------------------------------
* FILE NAME : scheduler.h
* AUTHOR    : Freescale Semiconductor, Inc.
* ----------------------------------------------------------------------------
* RELEASE HISTORY
* VERSION DATE AUTHOR DESCRIPTION
* (1.0) 11/01/2011   B32599 (Initial Template)
* ----------------------------------------------------------------------------
* KEYWORDS : Xtrinsic
* ----------------------------------------------------------------------------
* PURPOSE:
* ----------------------------------------------------------------------------
* REUSE ISSUES
*
* -FHDR-----------------------------------------------------------------------
*/


#ifndef SCHEDULER_H_
#define SCHEDULER_H_


/******************************************************************************
*******************************************************************************
*                             Scheduler				                          *
*******************************************************************************
*******************************************************************************/

/******************************************************************************
* Public Macros
*******************************************************************************/

#define User_INT_SFD			0		/* index of INTERRUPT SFD configuration */
#define User_INT_AFE_COCO		1		/* index of INTERRUPT AFE COCO bit configuration */
#define User_INT_IRQ			2		/* index of INTERRUPT IRQ configuration */
#define User_INT_TPMOV			3		/* index of INTERRUPT on TPM overflow */
#define User_INT_TPMCH0			4		/* index of INTERRUPT on TPM match CH0 register */
#define User_INT_TPMCH1			5		/* index of INTERRUPT on TPM match CH1 register */
#define User_INT_MTIMOV			6		/* index of INTERRUPT on MTIM register overflow */
#define User_INT_PDBA			7		/* index of INTERRUPT on PDB match modulo value */
#define User_INT_PDBB			8		/* index of INTERRUPT on PDB match modulo value */
#define User_INT_MSTIIC			9		/* index of INTERRUPT MASTER I2C configuration */
#define NUMS_OF_INTERRUPTS		10		/* number of interrupts */

/******************************************************************************
 Public type definitions
*******************************************************************************/

/* ----------------------------------------------------------------------------
 * FBID LIST
 * ----------------------------------------------------------------------------*/

typedef enum algid_tag {
	NO_APP_FBID                 = 0,
	SCHEDULER_FBID              = 1,
	CI_FBID                     = 2,
	GPIO_FBID                   = 3,
	MBOX_FBID                   = 4,
	TEST_VECTOR_CAPTURE_FBID    = 5,
	XYZ_DATA_FBID               = 6,
	PORTRAIT_LANDSCAPE_FBID     = 7,
	HIGH_G_DETECTION_FBID       = 8,
	LOW_G_DETECTION_FBID        = 9,
	PULSE_DETECTION_FBID        = 10,
	TILT_SENSING_FBID           = 11,
	FRAME_COUNTER_FBID          = 14,
	DATA_FIFO_FBID              = 15,
	EVENT_FIFO_FBID            	= 16,
	STATUS_REG_FBID             = 17,
	SLEEP_WAKE_FBID         	= 18,
	RST_CLR_SUSP_SYSID          = 23,
	MBOX_INTO_CFG_FBID          = 24,
    MAX_FBID                    = 32,
	NO_APP_FBID_INDX            = 0xff
} algid_t;

/* ----------------------------------------------------------------------------
 * SCHEDULER enum
 * ----------------------------------------------------------------------------*/

typedef enum activity_tag {
    NEVER    =  0, // never execute app
    INACTIVE =  1, // execute app only during low activity
    ACTIVE   =  2, // execute app only during high activity
    ALWAYS   =  3  // execute app during high and low activity
} activity_t;

typedef enum priority_tag {
    TASK488HZ   =  23, // start frame digital (AFE)
    TASK244HZ   =  22, // TPMOV, tpm counter overflow
    TASK122HZ   =  21, // TPMCH0, tpm channel 0
    TASK61HZ    =  20, // TPMCH1, tpm channel 1
    TASK30HZ    =  19, // TPMCH1, tpm channel 1
    TASK15HZ    =  18, // TPMCH1, tpm channel 1
    TASK7HZ     =  17, // PDBA
    TASK3HZ     =  16, // PDBB
    PRIORITY15  =  15,
    PRIORITY14  =  14,
    PRIORITY13  =  13,
    PRIORITY12  =  12,
    PRIORITY11  =  11,
    PRIORITY10  =  10,
    PRIORITY9   =  9,
    PRIORITY8   =  8,
    PRIORITY7   =  7,
    PRIORITY6   =  6,
    PRIORITY5   =  5,
    PRIORITY4   =  4,
    PRIORITY3   =  3,
    PRIORITY2   =  2,
    PRIORITY1   =  1,
    PRIORITY0   =  0, // MTIM counter overflow
    IDLE        = -1  // idle
} priority_t;


/* ----------------------------------------------------------------------------
 * SCHEDULER parameter structure
 * ----------------------------------------------------------------------------*/

typedef union task_status_tag{
	uint32_t Dword;
	struct {
		uint8_t	priority_idle	:1;
		uint8_t	priority0		:1;
		uint8_t	priority1		:1;
		uint8_t	priority2		:1;
		uint8_t	priority3		:1;
		uint8_t	priority4		:1;
		uint8_t	priority5		:1;
		uint8_t	priority6		:1;
		uint8_t	priority7		:1;
		uint8_t	priority8		:1;
		uint8_t	priority9		:1;
		uint8_t	priority10		:1;
		uint8_t	priority11		:1;
		uint8_t	priority12		:1;
		uint8_t	priority13		:1;
		uint8_t	priority14		:1;
		uint8_t	priority15		:1;
		uint8_t	priority16		:1;
		uint8_t	priority17		:1;
		uint8_t	priority18		:1;
		uint8_t	priority19		:1;
		uint8_t	priority20		:1;
		uint8_t	priority21		:1;
		uint8_t	priority22		:1;
		uint8_t	priority23		:1;
		uint8_t	Rsvd			:7;
	}bits;
}task_status_t;

typedef union sched_parms_tag {
    uint8_t Byte;
    struct {
        priority_t priority     :6; // which task to execute by the scheduler
        activity_t activity     :2; // execute during high and/or low activity
    } bits;
} sched_parms_t;


/* ----------------------------------------------------------------------------
 * SCHEDULER structure
 * ----------------------------------------------------------------------------*/

typedef struct scheduler_struct_tag {
    struct scheduler_outs_tag {
        task_status_t	timeout_status;
    }outs;
    struct scheduler_param_tag {
        task_status_t   request_to_start;
        task_status_t   user_interrupt[NUMS_OF_INTERRUPTS];
        sched_parms_t   sched_parms[MAX_FBID];
    }param;
} scheduler_struct_t;


#endif /* SCHEDULER_H_ */
